/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core;

import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.net.PasswordAuthentication;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IUserAuthenticatorService;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public class JSchUserInfo
implements UserInfo,
UIKeyboardInteractive {
    private boolean logging = false;
    private boolean firstTryPassphrase = true;
    private final IRemoteConnectionHostService hostService;
    private IUserAuthenticatorService userAuthenticatorService;

    public JSchUserInfo(IRemoteConnectionHostService hostService) {
        this.hostService = hostService;
    }

    public JSchUserInfo(IRemoteConnectionHostService hostService, IUserAuthenticatorService userAuthenticatorService) {
        this(hostService);
        this.userAuthenticatorService = userAuthenticatorService;
    }

    public String getPassphrase() {
        if (this.logging) {
            System.out.println("getPassphrase");
        }
        return this.hostService.getPassphrase();
    }

    public String getPassword() {
        if (this.logging) {
            System.out.println("getPassword");
        }
        return this.hostService.getPassword();
    }

    public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
        if (this.logging) {
            System.out.println("promptKeyboardInteractive:" + destination + ":" + name + ":" + instruction);
            String[] stringArray = prompt;
            int n = prompt.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                System.out.println(" " + p);
                ++n2;
            }
        }
        if (this.userAuthenticatorService != null) {
            String[] result = this.userAuthenticatorService.prompt(destination, name, instruction, prompt, echo);
            if (result != null && prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                this.hostService.setPassword(result[0]);
            }
            return result;
        }
        return null;
    }

    public boolean promptPassphrase(String message) {
        if (this.logging) {
            System.out.println("promptPassphrase:" + message);
        }
        if (this.firstTryPassphrase && !this.getPassphrase().equals("")) {
            this.firstTryPassphrase = false;
            return true;
        }
        if (this.userAuthenticatorService != null) {
            PasswordAuthentication auth = this.userAuthenticatorService.prompt(this.hostService.getUsername(), message);
            if (auth == null) {
                return false;
            }
            this.hostService.setUsername(auth.getUserName());
            this.hostService.setPassphrase(new String(auth.getPassword()));
            return true;
        }
        return false;
    }

    public boolean promptPassword(String message) {
        if (this.logging) {
            System.out.println("promptPassword:" + message);
        }
        if (this.userAuthenticatorService != null) {
            PasswordAuthentication auth = this.userAuthenticatorService.prompt(this.hostService.getUsername(), message);
            if (auth == null) {
                return false;
            }
            this.hostService.setUsername(auth.getUserName());
            this.hostService.setPassword(new String(auth.getPassword()));
            return true;
        }
        return false;
    }

    public boolean promptYesNo(String message) {
        if (this.logging) {
            System.out.println("promptYesNo:" + message);
        }
        if (this.userAuthenticatorService != null) {
            int prompt = this.userAuthenticatorService.prompt(3, Messages.AuthInfo_Authentication_message, message, new int[]{2, 3}, 2);
            return prompt == 2;
        }
        return true;
    }

    public void showMessage(String message) {
        if (this.logging) {
            System.out.println("showMessage:" + message);
        }
        if (this.userAuthenticatorService != null) {
            this.userAuthenticatorService.prompt(2, Messages.AuthInfo_Authentication_message, message, new int[1], 0);
        }
    }
}

