/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.resources;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.registry.LinuxStyle;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.resourcesstatus.ResourcesEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.Messages;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.timegraph.ITimeGraphEntryModelWeighted;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.ui.colors.ColorUtils;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class ResourcesPresentationProvider
extends TimeGraphPresentationProvider {
    private static final int SEPARATOR_HEIGHT = 4;
    private static final int NUM_COLORS = 25;
    private static final float BRIGHTNESS = 0.8f;
    private static final float SATURATION = 0.8f;
    private static final List<RGBAColor> PALETTE = new RotatingPaletteProvider.Builder().setNbColors(25).setBrightness(0.8f).setSaturation(0.8f).build().get();
    private static final int COLOR_DIFFERENCIATION_FACTOR = 14;
    private static final Map<Integer, StateItem> STATE_MAP;
    private static final List<StateItem> STATE_LIST;
    private static final StateItem[] STATE_TABLE;

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)0, (Object)new StateItem(LinuxStyle.IDLE.toMap()));
        builder.put((Object)2, (Object)new StateItem(LinuxStyle.USERMODE.toMap()));
        builder.put((Object)4, (Object)new StateItem(LinuxStyle.SYSCALL.toMap()));
        builder.put((Object)16, (Object)ResourcesPresentationProvider.createState(LinuxStyle.INTERRUPTED));
        builder.put((Object)8, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ));
        builder.put((Object)1, (Object)ResourcesPresentationProvider.createState(LinuxStyle.SOFT_IRQ_RAISED));
        STATE_MAP = builder.build();
        STATE_LIST = ImmutableList.copyOf(STATE_MAP.values());
        STATE_TABLE = STATE_LIST.toArray(new StateItem[STATE_LIST.size()]);
    }

    private static StateItem createState(LinuxStyle style) {
        return new StateItem(style.toMap());
    }

    private static StateItem getEventState(TimeEvent event) {
        if (event instanceof NullTimeEvent) {
            return null;
        }
        ITimeGraphEntry entry = event.getEntry();
        if (entry instanceof TimeGraphEntry && ((TimeGraphEntry)entry).getEntryModel() instanceof ResourcesEntryModel) {
            int value = event.getValue();
            ResourcesEntryModel resourcesModel = (ResourcesEntryModel)((TimeGraphEntry)entry).getEntryModel();
            ResourcesEntryModel.Type type = resourcesModel.getType();
            switch (type) {
                case CPU: {
                    return STATE_MAP.get(value);
                }
                case IRQ: {
                    return STATE_MAP.get(16);
                }
                case SOFT_IRQ: {
                    if (value == 1) {
                        return STATE_MAP.get(1);
                    }
                    return STATE_MAP.get(8);
                }
                case GROUP: {
                    return null;
                }
                case CURRENT_THREAD: 
                case FREQUENCY: {
                    if (!event.hasValue()) {
                        return null;
                    }
                    return STATE_MAP.get(2);
                }
            }
            return null;
        }
        return null;
    }

    public int getItemHeight(ITimeGraphEntry entry) {
        if (!entry.hasTimeEvents() && entry.getParent() != null) {
            return 4;
        }
        return super.getItemHeight(entry);
    }

    public int getStateTableIndex(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return STATE_LIST.indexOf(state);
        }
        if (event instanceof NullTimeEvent) {
            return -1;
        }
        return -2;
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public String getEventName(ITimeEvent event) {
        StateItem state = ResourcesPresentationProvider.getEventState((TimeEvent)event);
        if (state != null) {
            return state.getStateString();
        }
        if (event instanceof NullTimeEvent || ResourcesPresentationProvider.isType(event.getEntry(), ResourcesEntryModel.Type.CURRENT_THREAD)) {
            return null;
        }
        return Messages.ResourcesView_multipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        ITimeGraphEntry entry = event.getEntry();
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue() && entry instanceof TimeGraphEntry) {
            ITimeGraphDataProvider provider;
            ResourcesEntryModel resourcesModel;
            ITmfTreeDataModel model = ((TimeGraphEntry)entry).getEntryModel();
            TimeEvent tcEvent = (TimeEvent)event;
            if (tcEvent.hasValue() && model instanceof ResourcesEntryModel && ((resourcesModel = (ResourcesEntryModel)model).getType().equals((Object)ResourcesEntryModel.Type.IRQ) || resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.SOFT_IRQ) || resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.CPU) || resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.CURRENT_THREAD) || resourcesModel.getType().equals((Object)ResourcesEntryModel.Type.FREQUENCY)) && (provider = BaseDataProviderTimeGraphView.getProvider((TimeGraphEntry)((TimeGraphEntry)entry))) != null) {
                return ResourcesPresentationProvider.getTooltip((ITimeGraphDataProvider<? extends TimeGraphEntryModel>)provider, model.getId(), hoverTime);
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, String> getTooltip(ITimeGraphDataProvider<? extends TimeGraphEntryModel> provider, long id, long hoverTime) {
        SelectionTimeQueryFilter filter = new SelectionTimeQueryFilter(Collections.singletonList(hoverTime), Collections.singleton(id));
        TmfModelResponse response = provider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)filter), null);
        Map tooltip = (Map)response.getModel();
        if (tooltip == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> retMap = new LinkedHashMap<String, String>();
        retMap.putAll(tooltip);
        return retMap;
    }

    public Map<String, Object> getSpecificEventStyle(ITimeEvent event) {
        HashMap<String, Object> map = new HashMap<String, Object>(super.getSpecificEventStyle(event));
        if (ResourcesPresentationProvider.isType(event.getEntry(), ResourcesEntryModel.Type.CURRENT_THREAD) && event instanceof TimeEvent) {
            int threadEventValue = ((TimeEvent)event).getValue();
            RGBAColor color = PALETTE.get(Math.floorMod(threadEventValue + 14, 25));
            map.put("background-color", ColorUtils.toHexColor((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue()));
            map.put("style-name", String.valueOf(threadEventValue));
        } else if (event.getEntry() instanceof TimeGraphEntry && ((TimeGraphEntry)event.getEntry()).getEntryModel() instanceof ITimeGraphEntryModelWeighted) {
            ITimeGraphEntryModelWeighted model = (ITimeGraphEntryModelWeighted)((TimeGraphEntry)event.getEntry()).getEntryModel();
            int eventValue = ((TimeEvent)event).getValue();
            map.put("height", Float.valueOf((float)model.getWeight((long)eventValue)));
        }
        return map;
    }

    private static boolean isType(ITimeGraphEntry entry, ResourcesEntryModel.Type type) {
        ITmfTreeDataModel model;
        if (entry instanceof TimeGraphEntry && (model = ((TimeGraphEntry)entry).getEntryModel()) instanceof ResourcesEntryModel) {
            return ((ResourcesEntryModel)model).getType().equals((Object)type);
        }
        return false;
    }
}

