/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusViewer;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class RefactoringStatusDialog
extends Dialog {
    private RefactoringStatus fStatus;
    private String fWindowTitle;
    private boolean fBackButton;
    private boolean fLightWeight;

    public RefactoringStatusDialog(RefactoringStatus status, Shell parent, String windowTitle, boolean backButton) {
        super(parent);
        this.fStatus = status;
        this.fWindowTitle = windowTitle;
        this.fBackButton = backButton;
    }

    protected boolean isResizable() {
        return true;
    }

    public RefactoringStatusDialog(RefactoringStatus status, Shell parent, String windowTitle, boolean backButton, boolean light) {
        this(status, parent, windowTitle, backButton);
        this.fLightWeight = light;
    }

    public RefactoringStatusDialog(Shell parent, ErrorWizardPage page, boolean backButton) {
        this(page.getStatus(), parent, parent.getText(), backButton);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fWindowTitle);
    }

    protected int getDialogBoundsStrategy() {
        return 2;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        return DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"RefactoringStatusDialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        GridData gd = (GridData)result.getLayoutData();
        gd.widthHint = 800;
        gd.heightHint = 400;
        if (!this.fLightWeight) {
            Color background;
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            Color foreground = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_FOREGROUND");
            if (foreground == null) {
                foreground = JFaceColors.getInformationViewerForegroundColor((Display)parent.getDisplay());
            }
            if ((background = colorRegistry.get("org.eclipse.ui.workbench.INFORMATION_BACKGROUND")) == null) {
                background = JFaceColors.getInformationViewerForegroundColor((Display)parent.getDisplay());
            }
            ViewForm messagePane = new ViewForm(result, 0x800800);
            messagePane.marginWidth = 3;
            messagePane.marginHeight = 3;
            gd = new GridData(768);
            Rectangle rect = messagePane.computeTrim(0, 0, 0, this.convertHeightInCharsToPixels(2) + messagePane.marginHeight * 2);
            gd.heightHint = rect.height;
            messagePane.setLayoutData((Object)gd);
            messagePane.setForeground(foreground);
            messagePane.setBackground(background);
            Label label = new Label((Composite)messagePane, 16448);
            if (this.fStatus.hasFatalError()) {
                label.setText(RefactoringUIMessages.RefactoringStatusDialog_Cannot_proceed);
            } else {
                label.setText(RefactoringUIMessages.RefactoringStatusDialog_Please_look);
            }
            label.setForeground(foreground);
            label.setBackground(background);
            messagePane.setContent((Control)label);
        }
        RefactoringStatusViewer viewer = new RefactoringStatusViewer(result, 0);
        viewer.setLayoutData(new GridData(1808));
        viewer.setStatus(this.fStatus);
        RefactoringStatusDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.setReturnCode(14);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!this.fStatus.hasFatalError()) {
            if (this.fBackButton) {
                this.createButton(parent, 14, IDialogConstants.BACK_LABEL, false);
            }
            this.createButton(parent, 0, this.fLightWeight ? IDialogConstants.OK_LABEL : RefactoringUIMessages.RefactoringStatusDialog_Continue, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        } else {
            if (this.fBackButton) {
                this.createButton(parent, 14, IDialogConstants.BACK_LABEL, true);
            }
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, !this.fBackButton);
        }
    }
}

