/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.tests.trace;

import org.eclipse.tracecompass.ctf.core.tests.trace.PacketStub;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndex;
import org.eclipse.tracecompass.internal.ctf.core.trace.StreamInputPacketIndexEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CTFStreamInputPacketIndexTest {
    private StreamInputPacketIndex fFixture;

    @Before
    public void setUp() {
        this.fFixture = new StreamInputPacketIndex();
    }

    @Test
    public void testStreamInputPacketIndex() {
        Assert.assertNotNull((Object)this.fFixture);
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new StreamInputPacketIndexEntry(0L, 1L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, 0L, 0L)));
    }

    @Test
    public void testStreamInputPacketIndexGet() {
        Assert.assertNotNull((Object)this.fFixture);
        StreamInputPacketIndexEntry first = new StreamInputPacketIndexEntry(0L, 1L);
        PacketStub second = new PacketStub(1L, 0L, 0L);
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)first));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)second));
        Assert.assertEquals((Object)first, (Object)this.fFixture.getElement(0));
        Assert.assertEquals((Object)second, (Object)this.fFixture.getElement(1));
    }

    @Test
    public void testStreamInputPacketIndexContiguous() {
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, 0L, 1L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, 2L, 3L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(2L, 4L, 5L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(3L, 6L, 6L)));
        Assert.assertEquals((long)2L, (long)this.fFixture.search(5L));
    }

    @Test
    public void testStreamInputPacketIndexDisjoint() {
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, 0L, 1L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, 2L, 3L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(2L, 6L, 6L)));
        Assert.assertEquals((long)1L, (long)this.fFixture.search(5L));
        Assert.assertEquals((long)1L, (long)this.fFixture.search(3L));
    }

    @Test
    public void testStreamInputPacketIndexOverlapping() {
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, 0L, 1L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, 2L, 3L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(2L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(3L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(4L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(5L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(6L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(7L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(8L, 6L, 6L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(9L, 6L, 6L)));
        Assert.assertEquals((long)1L, (long)this.fFixture.search(5L));
        Assert.assertEquals((long)2L, (long)this.fFixture.search(6L));
    }

    @Test
    public void testStreamInputPacketIndexOverlappingBothSides() {
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, 0L, 3L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, 0L, 3L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(2L, 0L, 3L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(3L, 7L, 9L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(4L, 7L, 9L)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(5L, 7L, 9L)));
        Assert.assertEquals((long)0L, (long)this.fFixture.search(3L));
        Assert.assertEquals((long)2L, (long)this.fFixture.search(6L));
        Assert.assertEquals((long)3L, (long)this.fFixture.search(8L));
    }

    @Test
    public void testStreamInputPacketIndexLargeOverlapping() {
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, Long.MIN_VALUE, Long.MAX_VALUE)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, Long.MIN_VALUE, Long.MAX_VALUE)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(2L, Long.MIN_VALUE, Long.MAX_VALUE)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(3L, Long.MIN_VALUE, Long.MAX_VALUE)));
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(4L, Long.MIN_VALUE, Long.MAX_VALUE)));
        Assert.assertEquals((long)0L, (long)this.fFixture.search(5L));
        Assert.assertEquals((long)0L, (long)this.fFixture.search(6L));
    }

    @Test
    public void testStreamInputPacketIndexInvalidAppend() {
        this.fFixture = new StreamInputPacketIndex();
        Assert.assertTrue((boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, 0L, 1L)));
        Assert.assertFalse((String)"Same offset", (boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(0L, 1L, 2L)));
        Assert.assertFalse((String)"Before", (boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(1L, -1L, 0L)));
        Assert.assertFalse((String)"Empty", (boolean)this.fFixture.append((ICTFPacketDescriptor)new PacketStub(2L, 3L, 4L){

            @Override
            public long getContentSizeBits() {
                return 0L;
            }

            @Override
            public long getPayloadStartBits() {
                return 0L;
            }
        }));
    }
}

