/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQuery;
import org.eclipse.wst.sse.ui.internal.correction.AnnotationQueryResult;
import org.eclipse.wst.sse.ui.internal.correction.QuickFixRegistryReader;

public class QuickFixRegistry {
    private static QuickFixRegistry instance;
    private Map<AnnotationQuery, Map<AnnotationQueryResult, Collection<IConfigurationElement>>> resolutionQueries = new HashMap<AnnotationQuery, Map<AnnotationQueryResult, Collection<IConfigurationElement>>>();
    private static final String ATT_CLASS = "class";

    public static synchronized QuickFixRegistry getInstance() {
        if (instance == null) {
            instance = new QuickFixRegistry();
            new QuickFixRegistryReader().addHelp(instance);
        }
        return instance;
    }

    void addResolutionQuery(AnnotationQuery query, AnnotationQueryResult result, IConfigurationElement element) {
        this.addQuery(this.resolutionQueries, query, result, element);
    }

    private void addQuery(Map<AnnotationQuery, Map<AnnotationQueryResult, Collection<IConfigurationElement>>> table, AnnotationQuery query, AnnotationQueryResult result, IConfigurationElement element) {
        Map<AnnotationQueryResult, Collection<IConfigurationElement>> results = table.get(query);
        if (results == null) {
            results = new HashMap<AnnotationQueryResult, Collection<IConfigurationElement>>();
            table.put(query, results);
        }
        if (results.containsKey(result)) {
            Collection<IConfigurationElement> currentElements = results.get(result);
            currentElements.add(element);
        } else {
            HashSet<IConfigurationElement> configElements = new HashSet<IConfigurationElement>();
            configElements.add(element);
            results.put(result, configElements);
        }
    }

    public IQuickAssistProcessor[] getQuickFixProcessors(Annotation anno) {
        ArrayList<IQuickAssistProcessor> processors = new ArrayList<IQuickAssistProcessor>();
        for (AnnotationQuery query : this.resolutionQueries.keySet()) {
            Map<AnnotationQueryResult, Collection<IConfigurationElement>> resultsTable;
            AnnotationQueryResult result = null;
            try {
                result = query.performQuery(anno);
            }
            catch (Exception e) {
                Logger.logException((Throwable)e);
            }
            if (result == null || !(resultsTable = this.resolutionQueries.get(query)).containsKey(result)) continue;
            for (IConfigurationElement element : resultsTable.get(result)) {
                IQuickAssistProcessor processor = null;
                try {
                    processor = (IQuickAssistProcessor)element.createExecutableExtension(ATT_CLASS);
                }
                catch (CoreException coreException) {}
                if (processor == null) continue;
                processors.add(processor);
            }
        }
        return processors.toArray(new IQuickAssistProcessor[processors.size()]);
    }
}

