/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.condition;

import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.datastore.core.condition.ArrayTimeRangeCondition;
import org.eclipse.tracecompass.internal.datastore.core.condition.ContinuousTimeRangeCondition;
import org.eclipse.tracecompass.internal.datastore.core.condition.SingletonTimeRangeCondition;

public interface TimeRangeCondition {
    public long min();

    public long max();

    public boolean test(long var1);

    public boolean intersects(long var1, long var3);

    public @Nullable TimeRangeCondition subCondition(long var1, long var3);

    public static TimeRangeCondition singleton(long elem) {
        return new SingletonTimeRangeCondition(elem);
    }

    public static TimeRangeCondition forContinuousRange(long bound1, long bound2) {
        if (bound2 < bound1) {
            throw new IllegalArgumentException("Continuous time range condition: lower bound (" + bound1 + ") should be <= upper bound (" + bound2 + ')');
        }
        return new ContinuousTimeRangeCondition(bound1, bound2);
    }

    public static TimeRangeCondition forDiscreteRange(Collection<@NonNull Long> times) {
        return new ArrayTimeRangeCondition(times);
    }
}

