/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.statistics;

import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.NonNullUtils;

public class Statistics<@NonNull E>
implements IStatistics<E> {
    private final Function<E, @NonNull Long> fMapper;
    private @Nullable E fMin = null;
    private @Nullable E fMax = null;
    private long fNbElements = 0L;
    private double fMean = 0.0;
    private double fVariance = 0.0;
    private double fTotal = 0.0;

    public Statistics() {
        this(e -> {
            if (!(e instanceof Long)) {
                throw new IllegalStateException("The object " + e + " is not a number");
            }
            return (Long)e;
        });
    }

    public Statistics(Function<E, Long> mapper) {
        this.fMapper = mapper;
    }

    @Override
    public long getMin() {
        @Nullable E min = this.fMin;
        if (min == null) {
            return Long.MAX_VALUE;
        }
        return (Long)NonNullUtils.checkNotNull((Object)this.fMapper.apply(min));
    }

    @Override
    public long getMax() {
        @Nullable E max = this.fMax;
        if (max == null) {
            return Long.MIN_VALUE;
        }
        return (Long)NonNullUtils.checkNotNull((Object)this.fMapper.apply(max));
    }

    @Override
    public @Nullable E getMinObject() {
        return this.fMin;
    }

    @Override
    public @Nullable E getMaxObject() {
        return this.fMax;
    }

    @Override
    public long getNbElements() {
        return this.fNbElements;
    }

    @Override
    public double getMean() {
        return this.fMean;
    }

    @Override
    public double getStdDev() {
        return this.fNbElements > 2L ? Math.sqrt(this.fVariance / (double)(this.fNbElements - 1L)) : Double.NaN;
    }

    @Override
    public double getTotal() {
        return this.fTotal;
    }

    @Override
    public void update(E object) {
        Long value = (Long)NonNullUtils.checkNotNull((Object)this.fMapper.apply(object));
        this.fMin = value <= this.getMin() ? object : this.fMin;
        this.fMax = value >= this.getMax() ? object : this.fMax;
        ++this.fNbElements;
        double delta = (double)value.longValue() - this.fMean;
        this.fMean += delta / (double)this.fNbElements;
        this.fVariance += delta * ((double)value.longValue() - this.fMean);
        this.fTotal += (double)value.longValue();
    }

    @Override
    public void merge(IStatistics<E> o) {
        if (!(o instanceof Statistics)) {
            throw new IllegalArgumentException("Can only merge statistics of the same class");
        }
        Statistics other = (Statistics)o;
        if (other.fNbElements == 0L) {
            return;
        }
        if (this.fNbElements == 0L) {
            this.copy(other);
        } else if (other.fNbElements == 1L) {
            this.update(NonNullUtils.checkNotNull(other.getMaxObject()));
        } else if (this.fNbElements == 1L) {
            Statistics<Object> copyOther = new Statistics<Object>(this.fMapper);
            super.copy(other);
            copyOther.update(NonNullUtils.checkNotNull(this.getMaxObject()));
            this.copy(copyOther);
        } else {
            this.internalMerge(other);
        }
    }

    private void internalMerge(Statistics<E> other) {
        long min = this.getMin();
        long max = this.getMax();
        this.fMin = other.getMin() <= min ? other.getMinObject() : this.fMin;
        this.fMax = other.getMax() >= max ? other.getMaxObject() : this.fMax;
        long oldNbSeg = this.fNbElements;
        double oldAverage = this.fMean;
        long otherSegments = other.getNbElements();
        double otherAverage = other.getMean();
        this.fNbElements += otherSegments;
        this.fTotal += other.getTotal();
        this.fMean = ((double)oldNbSeg * oldAverage + otherAverage * (double)otherSegments) / (double)this.fNbElements;
        double avg1Sq = oldAverage * oldAverage;
        double avg2sq = otherAverage * otherAverage;
        double avgtSq = this.fMean * this.fMean;
        double variance1 = this.fVariance / (double)(oldNbSeg - 1L);
        double variance2 = other.fVariance / (double)(otherSegments - 1L);
        this.fVariance = (variance1 + avg1Sq - avgtSq) * (double)(oldNbSeg - 1L) + (variance2 + avg2sq - avgtSq) * (double)(otherSegments - 1L);
    }

    private void copy(Statistics<E> copyOther) {
        this.fMean = copyOther.fMean;
        this.fMax = copyOther.fMax;
        this.fMin = copyOther.fMin;
        this.fNbElements = copyOther.fNbElements;
        this.fTotal = copyOther.fTotal;
        this.fVariance = copyOther.fVariance;
    }

    public String toString() {
        return this.getClass() + ": Avg: " + this.getMean() + " on " + this.getNbElements() + " elements";
    }
}

