/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.trace.indexer;

import org.eclipse.tracecompass.internal.tmf.core.trace.indexer.TmfMemoryIndex;
import org.eclipse.tracecompass.tmf.core.tests.trace.indexer.AbstractCheckpointCollectionTest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.ITmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.indexer.checkpoint.TmfCheckpoint;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;
import org.junit.Assert;
import org.junit.Test;

public class TmfMemoryIndexTest
extends AbstractCheckpointCollectionTest {
    private TmfMemoryIndex fMemoryIndex;

    protected TmfMemoryIndex createCollection() {
        this.fMemoryIndex = new TmfMemoryIndex(this.getTrace());
        this.fCheckpointCollection = this.fMemoryIndex;
        return this.fMemoryIndex;
    }

    @Override
    @Test
    public void testInsert() {
        TmfCheckpoint checkpoint = new TmfCheckpoint(TmfTimestamp.fromSeconds((long)12345L), (ITmfLocation)new TmfLongLocation(123456L), 0L);
        this.fMemoryIndex.insert((ITmfCheckpoint)checkpoint);
        ITmfCheckpoint indexCheckpoint = this.fMemoryIndex.get(0L);
        Assert.assertEquals((Object)checkpoint, (Object)indexCheckpoint);
        long found = this.fMemoryIndex.binarySearch((ITmfCheckpoint)checkpoint);
        Assert.assertEquals((long)0L, (long)found);
    }

    @Test
    public void testBinarySearch() {
        long i = 0L;
        while (i < 50000L) {
            TmfCheckpoint checkpoint = new TmfCheckpoint(TmfTimestamp.fromSeconds((long)i), (ITmfLocation)new TmfLongLocation(i), 0L);
            this.fMemoryIndex.insert((ITmfCheckpoint)checkpoint);
            ++i;
        }
        TmfCheckpoint expectedCheckpoint = new TmfCheckpoint(TmfTimestamp.fromSeconds((long)122L), (ITmfLocation)new TmfLongLocation(122L), 0L);
        int expectedRank = 122;
        long rank = this.fMemoryIndex.binarySearch((ITmfCheckpoint)expectedCheckpoint);
        ITmfCheckpoint found = this.fMemoryIndex.get(rank);
        Assert.assertEquals((long)expectedRank, (long)rank);
        Assert.assertEquals((Object)found, (Object)expectedCheckpoint);
    }

    @Test
    public void testDispose() {
        this.fMemoryIndex.dispose();
        Assert.assertTrue((boolean)this.fMemoryIndex.isEmpty());
    }
}

