/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.tests.synchronization;

import java.math.BigDecimal;
import java.util.HashMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfConstantTransform;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransform;
import org.eclipse.tracecompass.internal.tmf.core.synchronization.TmfTimestampTransformLinear;
import org.eclipse.tracecompass.tmf.core.synchronization.ITmfTimestampTransform;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.junit.Assert;
import org.junit.Test;

public class TsTransformTest {
    private static final long ts = 1361657893526374091L;
    private static final @NonNull ITmfTimestamp oTs = TmfTimestamp.fromSeconds((long)1361657893526374091L);

    @Test
    public void testLinearTransform() {
        TmfTimestampTransformLinear ttl = new TmfTimestampTransformLinear();
        Assert.assertEquals((long)1361657893526374091L, (long)ttl.transform(1361657893526374091L));
        Assert.assertEquals((long)1361657893526374091L, (long)ttl.transform(oTs).getValue());
        ttl = new TmfTimestampTransformLinear(BigDecimal.valueOf(1.0), BigDecimal.valueOf(3L));
        Assert.assertEquals((long)1361657893526374094L, (long)ttl.transform(1361657893526374091L));
        Assert.assertEquals((long)1361657893526374094L, (long)ttl.transform(oTs).getValue());
        ttl = new TmfTimestampTransformLinear(BigDecimal.valueOf(2.0), BigDecimal.valueOf(0L));
        Assert.assertEquals((long)2723315787052748182L, (long)ttl.transform(1361657893526374091L));
        Assert.assertEquals((long)2723315787052748182L, (long)ttl.transform(oTs).getValue());
        ttl = new TmfTimestampTransformLinear(BigDecimal.valueOf(2.0), BigDecimal.valueOf(3L));
        Assert.assertEquals((long)2723315787052748185L, (long)ttl.transform(1361657893526374091L));
        Assert.assertEquals((long)2723315787052748185L, (long)ttl.transform(oTs).getValue());
        ttl = new TmfTimestampTransformLinear(BigDecimal.valueOf(0.5), BigDecimal.valueOf(0L));
        Assert.assertEquals((long)680828946763187045L, (long)ttl.transform(1361657893526374091L));
        Assert.assertEquals((long)680828946763187045L, (long)ttl.transform(oTs).getValue());
    }

    @Test
    public void testIdentityTransform() {
        TmfTimestampTransform tt = TmfTimestampTransform.IDENTITY;
        Assert.assertEquals((long)1361657893526374091L, (long)tt.transform(1361657893526374091L));
        Assert.assertEquals((Object)oTs, (Object)tt.transform(oTs));
    }

    @Test
    public void testEquality() {
        HashMap<Object, String> map = new HashMap<Object, String>();
        TmfTimestampTransformLinear ttl = new TmfTimestampTransformLinear(BigDecimal.valueOf(2.0), BigDecimal.valueOf(3L));
        TmfTimestampTransformLinear ttl2 = new TmfTimestampTransformLinear(BigDecimal.valueOf(2.0), BigDecimal.valueOf(3L));
        TmfTimestampTransformLinear ttl3 = new TmfTimestampTransformLinear(BigDecimal.valueOf(3L), BigDecimal.valueOf(3L));
        Assert.assertEquals((Object)ttl, (Object)ttl2);
        Assert.assertFalse((boolean)ttl.equals(ttl3));
        Assert.assertFalse((boolean)ttl2.equals(ttl3));
        map.put(ttl, "a");
        Assert.assertTrue((boolean)map.containsKey(ttl2));
        Assert.assertEquals((Object)"a", map.get(ttl));
        TmfTimestampTransform ti = TmfTimestampTransform.IDENTITY;
        Assert.assertEquals((Object)TmfTimestampTransform.IDENTITY, (Object)ti);
        Assert.assertFalse((boolean)TmfTimestampTransform.IDENTITY.equals(ttl));
        map.put(ti, "b");
        Assert.assertTrue((boolean)map.containsKey(TmfTimestampTransform.IDENTITY));
        Assert.assertEquals((Object)"b", map.get(ti));
        Assert.assertFalse((boolean)ti.equals(ttl));
        Assert.assertFalse((boolean)ttl.equals(ti));
    }

    @Test
    public void testEqualityConstantTransform() {
        TmfConstantTransform tt1 = new TmfConstantTransform(50L);
        TmfConstantTransform tt2 = new TmfConstantTransform(50L);
        TmfConstantTransform tt3 = new TmfConstantTransform(-10L);
        Assert.assertEquals((Object)tt1, (Object)tt2);
        Assert.assertNotEquals((Object)tt1, (Object)tt3);
        Assert.assertNotEquals((Object)tt2, (Object)tt3);
    }

    @Test
    public void testComposition() {
        long t = 100L;
        TmfTimestampTransform ti = TmfTimestampTransform.IDENTITY;
        TmfTimestampTransformLinear ttl = new TmfTimestampTransformLinear(BigDecimal.valueOf(2.0), BigDecimal.valueOf(3L));
        TmfTimestampTransformLinear ttl2 = new TmfTimestampTransformLinear(BigDecimal.valueOf(1.5), BigDecimal.valueOf(8L));
        ITmfTimestampTransform tc1 = ti.composeWith((ITmfTimestampTransform)ttl);
        Assert.assertEquals((Object)ttl, (Object)tc1);
        Assert.assertEquals((long)203L, (long)tc1.transform(t));
        tc1 = ttl.composeWith((ITmfTimestampTransform)ti);
        Assert.assertEquals((Object)ttl, (Object)tc1);
        Assert.assertEquals((long)203L, (long)tc1.transform(t));
        tc1 = ti.composeWith((ITmfTimestampTransform)ti);
        Assert.assertEquals((Object)tc1, (Object)TmfTimestampTransform.IDENTITY);
        Assert.assertEquals((long)100L, (long)tc1.transform(t));
        tc1 = ttl.composeWith((ITmfTimestampTransform)ttl2);
        Assert.assertEquals((long)ttl.transform(ttl2.transform(t)), (long)tc1.transform(t));
        Assert.assertEquals((long)319L, (long)tc1.transform(t));
        tc1 = ttl2.composeWith((ITmfTimestampTransform)ttl);
        Assert.assertEquals((long)ttl2.transform(ttl.transform(t)), (long)tc1.transform(t));
        Assert.assertEquals((long)312L, (long)tc1.transform(t));
    }
}

