/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils;

import java.util.regex.Pattern;

public class WindowsArgumentQuoter {
    private static Pattern spaces = Pattern.compile(".*\\s.*");

    public static String quoteArgv(String[] cmdarray, boolean force) {
        StringBuilder quoted = new StringBuilder();
        String[] stringArray = cmdarray;
        int n = cmdarray.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            WindowsArgumentQuoter.quoteArg(arg, quoted, force);
            quoted.append(' ');
            ++n2;
        }
        quoted.deleteCharAt(quoted.length() - 1);
        return quoted.toString();
    }

    private static void quoteArg(String arg, StringBuilder quoted, boolean force) {
        if (!(force || arg.isEmpty() || spaces.matcher(arg).matches())) {
            quoted.append(arg);
        } else {
            quoted.append('\"');
            int i = 0;
            while (i < arg.length()) {
                int numberBackslashes = 0;
                while (i < arg.length() && arg.charAt(i) == '\\') {
                    ++i;
                    ++numberBackslashes;
                }
                if (i == arg.length()) {
                    quoted.append("\\".repeat(numberBackslashes * 2));
                    break;
                }
                if (arg.charAt(i) == '\"') {
                    quoted.append("\\".repeat(numberBackslashes));
                    quoted.append('\"');
                } else {
                    quoted.append("\\".repeat(numberBackslashes));
                    quoted.append(arg.charAt(i));
                }
                ++i;
            }
            quoted.append('\"');
        }
    }
}

