/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.gnu.c.ICASTKnRFunctionDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTDeclarator;

public class CASTKnRFunctionDeclarator
extends CASTDeclarator
implements ICASTKnRFunctionDeclarator {
    IASTName[] parameterNames = IASTName.EMPTY_NAME_ARRAY;
    IASTDeclaration[] parameterDeclarations = IASTDeclaration.EMPTY_DECLARATION_ARRAY;

    public CASTKnRFunctionDeclarator() {
    }

    public CASTKnRFunctionDeclarator(IASTName[] parameterNames, IASTDeclaration[] parameterDeclarations) {
        this.setParameterNames(parameterNames);
        this.setParameterDeclarations(parameterDeclarations);
    }

    @Override
    public CASTKnRFunctionDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTKnRFunctionDeclarator copy(IASTNode.CopyStyle style) {
        CASTKnRFunctionDeclarator copy = new CASTKnRFunctionDeclarator();
        copy.parameterNames = new IASTName[this.parameterNames.length];
        int i = 0;
        while (i < this.parameterNames.length) {
            if (this.parameterNames[i] != null) {
                copy.parameterNames[i] = this.parameterNames[i].copy(style);
                copy.parameterNames[i].setParent(copy);
                copy.parameterNames[i].setPropertyInParent(PARAMETER_NAME);
            }
            ++i;
        }
        copy.parameterDeclarations = new IASTDeclaration[this.parameterDeclarations.length];
        i = 0;
        while (i < this.parameterDeclarations.length) {
            if (this.parameterDeclarations[i] != null) {
                copy.parameterDeclarations[i] = this.parameterDeclarations[i].copy(style);
                copy.parameterDeclarations[i].setParent(copy);
                copy.parameterDeclarations[i].setPropertyInParent(FUNCTION_PARAMETER);
            }
            ++i;
        }
        return this.copy(copy, style);
    }

    @Override
    public void setParameterNames(IASTName[] names) {
        this.assertNotFrozen();
        this.parameterNames = names;
        if (names != null) {
            IASTName[] iASTNameArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                IASTName name = iASTNameArray[n2];
                if (name != null) {
                    name.setParent(this);
                    name.setPropertyInParent(PARAMETER_NAME);
                }
                ++n2;
            }
        }
    }

    @Override
    public IASTName[] getParameterNames() {
        return this.parameterNames;
    }

    @Override
    public void setParameterDeclarations(IASTDeclaration[] decls) {
        this.assertNotFrozen();
        this.parameterDeclarations = decls;
        if (decls != null) {
            IASTDeclaration[] iASTDeclarationArray = decls;
            int n = decls.length;
            int n2 = 0;
            while (n2 < n) {
                IASTDeclaration decl = iASTDeclarationArray[n2];
                if (decl != null) {
                    decl.setParent(this);
                    decl.setPropertyInParent(FUNCTION_PARAMETER);
                }
                ++n2;
            }
        }
    }

    @Override
    public IASTDeclaration[] getParameterDeclarations() {
        return this.parameterDeclarations;
    }

    @Override
    protected boolean postAccept(ASTVisitor action) {
        IASTName[] ns = this.getParameterNames();
        int i = 0;
        while (i < ns.length) {
            if (!ns[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTDeclaration[] params = this.getParameterDeclarations();
        int i2 = 0;
        while (i2 < params.length) {
            if (!params[i2].accept(action)) {
                return false;
            }
            ++i2;
        }
        return super.postAccept(action);
    }

    @Override
    public IASTDeclarator getDeclaratorForParameterName(IASTName name) {
        boolean found = false;
        int i = 0;
        while (i < this.parameterNames.length) {
            if (this.parameterNames[i] == name) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            return null;
        }
        i = 0;
        while (i < this.parameterDeclarations.length) {
            if (this.parameterDeclarations[i] instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] decltors = ((IASTSimpleDeclaration)this.parameterDeclarations[i]).getDeclarators();
                int j = 0;
                while (j < decltors.length) {
                    if (decltors[j].getName().toString().equals(name.toString())) {
                        return decltors[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getRoleForName(IASTName name) {
        IASTName[] n = this.getParameterNames();
        int i = 0;
        while (i < n.length) {
            if (n[i] == name) {
                return 3;
            }
            ++i;
        }
        return super.getRoleForName(name);
    }
}

