/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.internal;

import java.nio.channels.ClosedChannelException;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.TypeUtil;

public class ContentSourceRange
implements Content.Source {
    private final long _offset;
    private final long _length;
    private final Content.Source _source;
    private final boolean _readToEof;
    private long _offsetRemaining;
    private long _lengthRemaining;
    private Content.Chunk _terminal;

    public ContentSourceRange(Content.Source source, long offset, long length) {
        this(source, offset, length, false);
    }

    public ContentSourceRange(Content.Source source, long offset, long length, boolean readToEof) {
        this._source = source;
        this._offset = offset;
        this._length = TypeUtil.checkOffsetLengthSize((long)offset, (long)length, (long)source.getLength());
        this._offsetRemaining = this._offset;
        this._lengthRemaining = this._length;
        this._readToEof = readToEof;
    }

    @Override
    public long getLength() {
        return this._length;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Content.Chunk read() {
        block6: {
            block7: {
                if (this._terminal != null) {
                    chunk = this._terminal;
                    this._terminal = Content.Chunk.next(chunk);
                    return chunk;
                }
                do lbl-1000:
                // 3 sources

                {
                    block8: {
                        block9: {
                            if ((chunk = this._source.read()) == null) {
                                return null;
                            }
                            if (Content.Chunk.isFailure(chunk)) {
                                this._terminal = Content.Chunk.next(chunk);
                                return chunk;
                            }
                            if (this._offsetRemaining <= 0L) break block8;
                            if (this._offsetRemaining < (long)chunk.remaining()) break block9;
                            this._offsetRemaining -= (long)chunk.remaining();
                            chunk.release();
                            if (!chunk.isLast()) ** GOTO lbl-1000
                            this._terminal = Content.Chunk.EOF;
                            return this._terminal;
                        }
                        slice = chunk.slice();
                        chunk.release();
                        while (this._offsetRemaining > 0L) {
                            this._offsetRemaining -= slice.skip(this._offsetRemaining);
                        }
                        chunk = Content.Chunk.from(slice, chunk.isLast());
                    }
                    if (this._lengthRemaining != 0L) break block6;
                    if (!this._readToEof) break block7;
                    chunk.release();
                } while (!chunk.isLast());
                this._terminal = Content.Chunk.EOF;
                return this._terminal;
            }
            this.fail(new ClosedChannelException());
            this._terminal = Content.Chunk.EOF;
            return this._terminal;
        }
        if (this._lengthRemaining > 0L && this._lengthRemaining < (long)chunk.remaining()) {
            slice = chunk.slice(this._lengthRemaining);
            this._lengthRemaining = 0L;
            chunk.release();
            return Content.Chunk.from(slice, chunk.isLast());
        }
        this._lengthRemaining -= (long)chunk.remaining();
        return chunk;
    }

    @Override
    public void demand(Runnable demandCallback) {
        this._source.demand(demandCallback);
    }

    @Override
    public void fail(Throwable failure) {
        this._source.fail(failure);
    }

    @Override
    public void fail(Throwable failure, boolean last) {
        this._source.fail(failure, last);
    }

    @Override
    public boolean rewind() {
        boolean rewound = this._source.rewind();
        if (rewound) {
            this._offsetRemaining = this._offset;
            this._lengthRemaining = this._length;
        }
        return rewound;
    }

    public String toString() {
        return String.format("%s{off=%s, len=%s, source=%s}", this.getClass().getSimpleName(), this._offset, this._length, this._source);
    }
}

