/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.text.quicksearch.internal.core.LineItem;
import org.eclipse.text.quicksearch.internal.core.QuickTextQuery;
import org.eclipse.text.quicksearch.internal.core.QuickTextSearchRequestor;
import org.eclipse.text.quicksearch.internal.core.ResourceWalker;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatcher;
import org.eclipse.text.quicksearch.internal.core.pathmatch.ResourceMatchers;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.util.LightSchedulingRule;
import org.eclipse.text.quicksearch.internal.util.LineReader;

public class QuickTextSearcher {
    private static int MAX_BUFFER_LENGTH = 999999;
    private final QuickTextSearchRequestor requestor;
    private QuickTextQuery query;
    private final Set<LineItem> matches = ConcurrentHashMap.newKeySet(2000);
    private ISchedulingRule matchesRule = new LightSchedulingRule("QuickSearchMatchesRule");
    private final SearchInFilesWalker walker;
    private IncrementalUpdateJob incrementalUpdate;
    private QuickTextQuery newQuery;
    public static final int DEFAULT_MAX_RESULTS = 200;
    private int maxResults = 200;
    private int MAX_LINE_LEN;
    private volatile IFile currentFile = null;
    public volatile int searchTookMs;
    private boolean forceRefresh = false;
    private ResourceMatcher pathMatcher = ResourceMatchers.ANY;

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public QuickTextSearcher(QuickTextQuery query, final PriorityFunction priorities, int maxLineLen, QuickTextSearchRequestor requestor) {
        this.MAX_LINE_LEN = maxLineLen;
        this.requestor = requestor;
        this.query = query;
        this.walker = this.createWalker(new PriorityFunction(){

            @Override
            public double priority(IResource r) {
                double basePriority = priorities.priority(r);
                if (basePriority == Double.NEGATIVE_INFINITY) {
                    return basePriority;
                }
                if (r.getType() == 1 && !QuickTextSearcher.this.pathMatcher.matches(r)) {
                    return Double.NEGATIVE_INFINITY;
                }
                return basePriority;
            }
        });
    }

    private SearchInFilesWalker createWalker(PriorityFunction priorities) {
        SearchInFilesWalker job = new SearchInFilesWalker();
        job.setPriorityFun(priorities);
        job.setRule(this.matchesRule);
        job.schedule();
        return job;
    }

    private static String toShortString(IFile file) {
        byte[] content;
        block3: {
            try {
                content = file.readNBytes(MAX_BUFFER_LENGTH);
                int length = content.length;
                if (length < MAX_BUFFER_LENGTH) break block3;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        String charset = file.getCharset();
        return new String(content, charset);
    }

    private void add(LineItem line) {
        if (!this.isActive()) {
            this.walker.suspend();
        } else if (this.matches.add(line)) {
            this.requestor.add(line);
        }
    }

    public void setQuery(QuickTextQuery newQuery, boolean force) {
        if (newQuery.equalsFilter(this.query) && !force) {
            return;
        }
        this.newQuery = newQuery;
        this.forceRefresh = force;
        this.scheduleIncrementalUpdate();
    }

    public void setPathMatcher(ResourceMatcher pathMatcher) {
        if (this.pathMatcher.equals(pathMatcher)) {
            return;
        }
        this.pathMatcher = pathMatcher;
        this.setQuery(this.query, true);
    }

    public QuickTextQuery getQuery() {
        return this.newQuery != null ? this.newQuery : this.query;
    }

    private synchronized void scheduleIncrementalUpdate() {
        this.walker.suspend();
        if (this.incrementalUpdate != null) {
            this.incrementalUpdate.cancel();
        }
        this.incrementalUpdate = new IncrementalUpdateJob();
        this.incrementalUpdate.schedule();
    }

    public boolean isActive() {
        return !this.isDone() && this.matches.size() < this.maxResults;
    }

    public boolean isDone() {
        return this.walker.isDone();
    }

    public void cancel() {
        this.walker.cancel();
        IncrementalUpdateJob incrementalUpdateJob = this.incrementalUpdate;
        if (incrementalUpdateJob instanceof IncrementalUpdateJob) {
            IncrementalUpdateJob update = incrementalUpdateJob;
            update.cancel();
        }
    }

    public IFile getCurrentFile() {
        return this.currentFile;
    }

    static /* synthetic */ void access$0(QuickTextSearcher quickTextSearcher, LineItem lineItem) {
        quickTextSearcher.add(lineItem);
    }

    private class IncrementalUpdateJob
    extends Job {
        public IncrementalUpdateJob() {
            super(Messages.QuickTextSearch_updateMatchesJob);
            this.setRule(QuickTextSearcher.this.matchesRule);
        }

        protected IStatus run(IProgressMonitor monitor) {
            QuickTextQuery nq = QuickTextSearcher.this.newQuery;
            if (!QuickTextSearcher.this.forceRefresh && QuickTextSearcher.this.query.isSubFilter(nq)) {
                QuickTextSearcher.this.query = nq;
                this.performIncrementalUpdate(monitor);
            } else {
                QuickTextSearcher.this.query = nq;
                QuickTextSearcher.this.forceRefresh = false;
                if (!monitor.isCanceled()) {
                    this.performRestart();
                }
            }
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        private void performIncrementalUpdate(IProgressMonitor mon) {
            Iterator<LineItem> items = QuickTextSearcher.this.matches.iterator();
            while (items.hasNext() && !mon.isCanceled()) {
                LineItem item = items.next();
                Matcher matcher = QuickTextSearcher.this.query.pattern.matcher(item.getText());
                if (matcher.find()) {
                    QuickTextSearcher.this.requestor.update(item);
                    continue;
                }
                items.remove();
                QuickTextSearcher.this.requestor.revoke(item);
            }
            if (!mon.isCanceled()) {
                QuickTextSearcher.this.walker.resume();
            }
        }

        private void performRestart() {
            QuickTextSearcher.this.matches.clear();
            QuickTextSearcher.this.requestor.clear();
            QuickTextSearcher.this.walker.cancel();
            if (!QuickTextSearcher.this.query.isTrivial()) {
                QuickTextSearcher.this.walker.init();
                QuickTextSearcher.this.walker.resume();
            } else {
                QuickTextSearcher.this.walker.stop();
            }
        }
    }

    private final class SearchInFilesWalker
    extends ResourceWalker {
        private SearchInFilesWalker() {
        }

        @Override
        public IStatus run(IProgressMonitor monitor) {
            QuickTextSearcher.this.searchTookMs = 0;
            long n0 = System.nanoTime();
            try {
                IStatus iStatus = super.run(monitor);
                return iStatus;
            }
            finally {
                QuickTextSearcher.this.currentFile = null;
                long n1 = System.nanoTime();
                if (QuickTextSearcher.this.matches.isEmpty()) {
                    QuickTextSearcher.this.searchTookMs = (int)((n1 - n0) / 1000000L);
                }
            }
        }

        @Override
        protected boolean searchIn(IFile f, BooleanSupplier canceled) {
            QuickTextSearcher.this.currentFile = f;
            return SearchInFilesWalker.search(f, canceled, QuickTextSearcher.this.MAX_LINE_LEN, QuickTextSearcher.this.query.pattern, arg_0 -> QuickTextSearcher.access$0(QuickTextSearcher.this, arg_0));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean search(IFile f, BooleanSupplier canceled, int maxLineLength, Pattern pattern, Consumer<LineItem> add) {
            if (canceled.getAsBoolean()) {
                return false;
            }
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (LineReader lr = new LineReader(SearchInFilesWalker.getReader(f), maxLineLength);){
                    int lineIndex = 1;
                    while (true) {
                        String line;
                        if ((line = lr.readLine()) == null) {
                            return true;
                        }
                        int offset = lr.getLastLineOffset();
                        if (canceled.getAsBoolean()) {
                            return false;
                        }
                        Matcher matcher = pattern.matcher(line);
                        if (matcher.find()) {
                            LineItem lineItem = new LineItem(f, line, lineIndex, offset);
                            add.accept(lineItem);
                        }
                        ++lineIndex;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        private static Reader getReader(IFile f) throws UnsupportedEncodingException, CoreException {
            String shortString = QuickTextSearcher.toShortString(f);
            if (shortString != null) {
                return new StringReader(shortString);
            }
            return new InputStreamReader(f.getContents(true), f.getCharset());
        }

        @Override
        public void resume() {
            if (QuickTextSearcher.this.isActive()) {
                super.resume();
            }
        }
    }
}

