/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.statevalue;

import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.statevalue.StateValueTestBase;
import org.junit.Assert;
import org.junit.Test;

public class NullStateValueTest
extends StateValueTestBase {
    private static final TmfStateValue STATE_VALUE = TmfStateValue.nullValue();

    @Override
    protected ITmfStateValue getStateValueFixture() {
        return STATE_VALUE;
    }

    @Override
    protected ITmfStateValue.Type getStateValueType() {
        return ITmfStateValue.Type.NULL;
    }

    @Override
    @Test
    public void testUnboxInt() {
        int unboxed = STATE_VALUE.unboxInt();
        Assert.assertEquals((long)-1L, (long)unboxed);
    }

    @Override
    @Test
    public void testUnboxLong() {
        long unboxed = STATE_VALUE.unboxLong();
        Assert.assertEquals((long)-1L, (long)unboxed);
    }

    @Override
    @Test
    public void testUnboxDouble() {
        double unboxed = STATE_VALUE.unboxDouble();
        Assert.assertEquals((double)Double.NaN, (double)unboxed, (double)1.0E-5);
    }

    @Override
    @Test
    public void testUnboxStr() {
        String unboxed = STATE_VALUE.unboxStr();
        Assert.assertEquals((Object)"nullValue", (Object)unboxed);
    }

    @Override
    @Test
    public void testIsNull() {
        Assert.assertTrue((boolean)STATE_VALUE.isNull());
    }
}

