/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend.historytree;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@NonNullByDefault(value={})
public class HTIntervalStringReadWriteTest {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private int fNbChars;
    private int fCharLength;
    private char fChar;

    @Parameterized.Parameters(name="nb of chars: {0}, char length: {1}")
    public static Iterable<Object[]> getTestParams() {
        Set set = Sets.cartesianProduct((List)ImmutableList.of((Object)ImmutableSet.of((Object)0, (Object)10, (Object)126, (Object)127, (Object)128, (Object)16382, (Object[])new Integer[]{16383, 16384, 10921, 10922, 10923, 32766, Short.MAX_VALUE, 32768}), (Object)ImmutableSet.of((Object)1, (Object)2, (Object)3)));
        return set.stream().map(List::toArray).collect(Collectors.toList());
    }

    public HTIntervalStringReadWriteTest(Integer nbChars, Integer charLength) {
        this.fNbChars = nbChars;
        this.fCharLength = charLength;
        switch (charLength) {
            case 1: {
                this.fChar = (char)97;
                break;
            }
            case 2: {
                this.fChar = (char)233;
                break;
            }
            case 3: {
                this.fChar = (char)38271;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Test
    public void testStringWithChars() throws IOException {
        StringBuilder sb = new StringBuilder();
        IntStream.range(0, this.fNbChars).forEach(i -> {
            StringBuilder stringBuilder2 = sb.append(this.fChar);
        });
        String str = sb.toString();
        Assert.assertEquals((long)this.fNbChars, (long)str.length());
        Assert.assertEquals((long)(this.fNbChars * this.fCharLength), (long)str.getBytes(CHARSET).length);
        if (this.fNbChars * this.fCharLength > Short.MAX_VALUE) {
            try {
                new HTInterval(0L, 10L, 1, (Object)str);
            }
            catch (IllegalArgumentException e) {
                return;
            }
            Assert.fail();
        }
        HTInterval interval = new HTInterval(0L, 10L, 1, (Object)str);
        HTIntervalStringReadWriteTest.writeAndReadInterval(interval);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void writeAndReadInterval(HTInterval interval) throws IOException {
        HTInterval readInterval;
        block27: {
            Throwable throwable;
            File tempFile;
            int sizeOnDisk;
            block25: {
                sizeOnDisk = interval.getSizeOnDisk();
                tempFile = File.createTempFile("test-interval", ".interval");
                Throwable throwable2 = null;
                throwable = null;
                try {
                    FileOutputStream fos = new FileOutputStream(tempFile, false);
                    try {
                        try (FileChannel fc = fos.getChannel();){
                            ByteBuffer bb = ByteBuffer.allocate(sizeOnDisk);
                            bb.order(ByteOrder.LITTLE_ENDIAN);
                            bb.clear();
                            interval.writeInterval(bb, 1L);
                            bb.flip();
                            int written = fc.write(bb);
                            Assert.assertEquals((long)sizeOnDisk, (long)written);
                        }
                        if (fos == null) break block25;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (fos == null) throw throwable2;
                        fos.close();
                        throw throwable2;
                    }
                    fos.close();
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    }
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                    throw throwable2;
                }
            }
            throwable = null;
            Object var5_9 = null;
            try {
                FileInputStream fis = new FileInputStream(tempFile);
                try {
                    try (FileChannel fc = fis.getChannel();){
                        ByteBuffer bb = ByteBuffer.allocate(sizeOnDisk);
                        bb.order(ByteOrder.LITTLE_ENDIAN);
                        bb.clear();
                        int read = fc.read(bb);
                        Assert.assertEquals((long)sizeOnDisk, (long)read);
                        bb.flip();
                        readInterval = HTInterval.readFrom((ByteBuffer)bb, (long)1L);
                    }
                    if (fis == null) break block27;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                    } else if (throwable != throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    if (fis == null) throw throwable;
                    fis.close();
                    throw throwable;
                }
                fis.close();
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                    throw throwable;
                }
                if (throwable == throwable6) throw throwable;
                throwable.addSuppressed(throwable6);
                throw throwable;
            }
        }
        Assert.assertEquals((Object)interval, (Object)readInterval);
    }
}

