/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.util.PriorityQueue;

public abstract class TopDocsCollector<T extends ScoreDoc>
implements Collector {
    public static final TopDocs EMPTY_TOPDOCS = new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
    protected final PriorityQueue<T> pq;
    protected int totalHits;
    protected TotalHits.Relation totalHitsRelation = TotalHits.Relation.EQUAL_TO;

    protected TopDocsCollector(PriorityQueue<T> pq) {
        this.pq = pq;
    }

    protected void populateResults(ScoreDoc[] results, int howMany) {
        for (int i = howMany - 1; i >= 0; --i) {
            results[i] = (ScoreDoc)this.pq.pop();
        }
    }

    protected TopDocs newTopDocs(ScoreDoc[] results, int start) {
        return results == null ? EMPTY_TOPDOCS : new TopDocs(new TotalHits(this.totalHits, this.totalHitsRelation), results);
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    protected int topDocsSize() {
        return this.totalHits < this.pq.size() ? this.totalHits : this.pq.size();
    }

    public TopDocs topDocs() {
        return this.topDocs(0, this.topDocsSize());
    }

    public TopDocs topDocs(int start) {
        return this.topDocs(start, this.topDocsSize());
    }

    public TopDocs topDocs(int start, int howMany) {
        int size = this.topDocsSize();
        if (howMany < 0) {
            throw new IllegalArgumentException("Number of hits requested must be greater than 0 but value was " + howMany);
        }
        if (start < 0) {
            throw new IllegalArgumentException("Expected value of starting position is between 0 and " + size + ", got " + start);
        }
        if (start >= size || howMany == 0) {
            return this.newTopDocs(null, start);
        }
        howMany = Math.min(size - start, howMany);
        ScoreDoc[] results = new ScoreDoc[howMany];
        for (int i = this.pq.size() - start - howMany; i > 0; --i) {
            this.pq.pop();
        }
        this.populateResults(results, howMany);
        return this.newTopDocs(results, start);
    }
}

