/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.SWTFontProvider;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.PointF;
import org.eclipse.swt.internal.gdip.RectF;
import org.eclipse.swt.internal.win32.OS;

public class Path
extends Resource {
    private int initialZoom;
    private HashMap<Integer, Long> zoomLevelToHandle = new HashMap();
    PointF currentPoint = new PointF();
    PointF startPoint = new PointF();

    public Path(Device device) {
        this(device, DPIUtil.getDeviceZoom());
    }

    private Path(Device device, int zoom) {
        super(device);
        this.device.checkGDIP();
        this.initialZoom = zoom;
        long handle = Gdip.GraphicsPath_new(0);
        if (handle == 0L) {
            SWT.error(2);
        }
        this.zoomLevelToHandle.put(this.initialZoom, handle);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        flatness = Math.max(0.0f, flatness);
        long handle = Gdip.GraphicsPath_Clone(path.getHandle(path.initialZoom));
        if (flatness != 0.0f) {
            Gdip.GraphicsPath_Flatten(handle, 0L, flatness);
        }
        if (handle == 0L) {
            SWT.error(2);
        }
        this.initialZoom = path.initialZoom;
        this.zoomLevelToHandle.put(this.initialZoom, handle);
        this.init();
        this.device.registerResourceWithZoomSupport(this);
    }

    public Path(Device device, PathData data) {
        this(device, data, DPIUtil.getDeviceZoom());
    }

    private Path(Device device, PathData data, int zoom) {
        this(device, zoom);
        if (data == null) {
            SWT.error(4);
        }
        this.init(data);
        this.device.registerResourceWithZoomSupport(this);
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (width == 0.0f || height == 0.0f || arcAngle == 0.0f) {
            return;
        }
        Device drawable = this.getDevice();
        x = DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom);
        y = DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom);
        width = DPIUtil.scaleUp((Drawable)drawable, width, this.initialZoom);
        height = DPIUtil.scaleUp((Drawable)drawable, height, this.initialZoom);
        this.addArcInPixels(x, y, width, height, startAngle, arcAngle);
    }

    void addArcInPixels(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (width < 0.0f) {
            x += width;
            width = -width;
        }
        if (height < 0.0f) {
            y += height;
            height = -height;
        }
        if (width == height) {
            Gdip.GraphicsPath_AddArc(this.getHandle(this.initialZoom), x, y, width, height, -startAngle, -arcAngle);
        } else {
            long matrix;
            long path = Gdip.GraphicsPath_new(0);
            if (path == 0L) {
                SWT.error(2);
            }
            if ((matrix = Gdip.Matrix_new(width, 0.0f, 0.0f, height, x, y)) == 0L) {
                SWT.error(2);
            }
            Gdip.GraphicsPath_AddArc(path, 0.0f, 0.0f, 1.0f, 1.0f, -startAngle, -arcAngle);
            Gdip.GraphicsPath_Transform(path, matrix);
            Gdip.GraphicsPath_AddPath(this.getHandle(this.initialZoom), path, true);
            Gdip.Matrix_delete(matrix);
            Gdip.GraphicsPath_delete(path);
        }
        Gdip.GraphicsPath_GetLastPoint(this.getHandle(this.initialZoom), this.currentPoint);
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        Gdip.GraphicsPath_AddPath(this.getHandle(this.initialZoom), path.getHandle(this.initialZoom), false);
        this.currentPoint.X = path.currentPoint.X;
        this.currentPoint.Y = path.currentPoint.Y;
    }

    public void addRectangle(float x, float y, float width, float height) {
        this.addRectangleInPixels(x, y, width, height);
    }

    void addRectangleInPixels(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        RectF rect = new RectF();
        rect.X = x;
        rect.Y = y;
        rect.Width = width;
        rect.Height = height;
        Gdip.GraphicsPath_AddRectangle(this.getHandle(this.initialZoom), rect);
        this.currentPoint.X = x;
        this.currentPoint.Y = y;
    }

    public void addString(String string, float x, float y, Font font) {
        Device drawable = this.getDevice();
        x = DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom);
        y = DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom);
        this.addStringInPixels(string, x, y, font);
    }

    void addStringInPixels(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        char[] buffer = string.toCharArray();
        long hDC = this.device.internal_new_GC(null);
        long[] family = new long[1];
        long gdipFont = GC.createGdipFont(hDC, SWTFontProvider.getFont((Device)this.device, (FontData)font.getFontData()[0], (int)this.initialZoom).handle, 0L, this.device.fontCollection, family, null);
        PointF point = new PointF();
        point.X = x - Gdip.Font_GetSize(gdipFont) / 6.0f;
        point.Y = y;
        int style = Gdip.Font_GetStyle(gdipFont);
        float size = Gdip.Font_GetSize(gdipFont);
        Gdip.GraphicsPath_AddString(this.getHandle(this.initialZoom), buffer, buffer.length, family[0], style, size, point, 0L);
        Gdip.GraphicsPath_GetLastPoint(this.getHandle(this.initialZoom), this.currentPoint);
        Gdip.FontFamily_delete(family[0]);
        Gdip.Font_delete(gdipFont);
        this.device.internal_dispose_GC(hDC, null);
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_CloseFigure(this.getHandle(this.initialZoom));
        this.currentPoint.X = this.startPoint.X;
        this.currentPoint.Y = this.startPoint.Y;
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        Device drawable = this.getDevice();
        x = DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom);
        y = DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom);
        return this.containsInPixels(x, y, gc, outline);
    }

    boolean containsInPixels(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        gc.initGdip();
        gc.checkGC(120);
        int mode = OS.GetPolyFillMode(gc.handle) == 2 ? 1 : 0;
        Gdip.GraphicsPath_SetFillMode(this.getHandle(this.initialZoom), mode);
        if (outline) {
            return Gdip.GraphicsPath_IsOutlineVisible(this.getHandle(this.initialZoom), x, y, gc.data.gdipPen, gc.data.gdipGraphics);
        }
        return Gdip.GraphicsPath_IsVisible(this.getHandle(this.initialZoom), x, y, gc.data.gdipGraphics);
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        Device drawable = this.getDevice();
        cx1 = DPIUtil.scaleUp((Drawable)drawable, cx1, this.initialZoom);
        cy1 = DPIUtil.scaleUp((Drawable)drawable, cy1, this.initialZoom);
        cx2 = DPIUtil.scaleUp((Drawable)drawable, cx2, this.initialZoom);
        cy2 = DPIUtil.scaleUp((Drawable)drawable, cy2, this.initialZoom);
        x = DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom);
        y = DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom);
        this.cubicToInPixels(cx1, cy1, cx2, cy2, x, y);
    }

    void cubicToInPixels(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddBezier(this.getHandle(this.initialZoom), this.currentPoint.X, this.currentPoint.Y, cx1, cy1, cx2, cy2, x, y);
        Gdip.GraphicsPath_GetLastPoint(this.getHandle(this.initialZoom), this.currentPoint);
    }

    @Override
    void destroy() {
        this.device.deregisterResourceWithZoomSupport(this);
        this.zoomLevelToHandle.values().forEach(Gdip::GraphicsPath_delete);
        this.zoomLevelToHandle.clear();
    }

    @Override
    void destroyHandlesExcept(Set<Integer> zoomLevels) {
        this.zoomLevelToHandle.entrySet().removeIf(entry -> {
            Integer zoom = (Integer)entry.getKey();
            if (!zoomLevels.contains(zoom) && zoom != this.initialZoom) {
                Gdip.GraphicsPath_delete((Long)entry.getValue());
                return true;
            }
            return false;
        });
    }

    public void getBounds(float[] bounds) {
        if (bounds == null) {
            SWT.error(4);
        }
        this.getBoundsInPixels(bounds);
        float[] scaledbounds = DPIUtil.scaleDown((Drawable)this.getDevice(), bounds, this.initialZoom);
        System.arraycopy(scaledbounds, 0, bounds, 0, 4);
    }

    void getBoundsInPixels(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
        RectF rect = new RectF();
        Gdip.GraphicsPath_GetBounds(this.getHandle(this.initialZoom), rect, 0L, 0L);
        bounds[0] = rect.X;
        bounds[1] = rect.Y;
        bounds[2] = rect.Width;
        bounds[3] = rect.Height;
    }

    public void getCurrentPoint(float[] point) {
        if (point == null) {
            SWT.error(4);
        }
        this.getCurrentPointInPixels(point);
        float[] scaledpoint = DPIUtil.scaleDown((Drawable)this.getDevice(), point, this.initialZoom);
        System.arraycopy(scaledpoint, 0, point, 0, 2);
    }

    void getCurrentPointInPixels(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
        point[0] = this.currentPoint.X;
        point[1] = this.currentPoint.Y;
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        PathData result = this.getPathDataInPixels();
        result.points = DPIUtil.scaleDown((Drawable)this.getDevice(), result.points, this.initialZoom);
        return result;
    }

    PathData getPathDataInPixels() {
        int count = Gdip.GraphicsPath_GetPointCount(this.getHandle(this.initialZoom));
        byte[] gdipTypes = new byte[count];
        float[] points = new float[count * 2];
        Gdip.GraphicsPath_GetPathTypes(this.getHandle(this.initialZoom), gdipTypes, count);
        Gdip.GraphicsPath_GetPathPoints(this.getHandle(this.initialZoom), points, count);
        byte[] types = new byte[count * 2];
        int index = 0;
        int typesIndex = 0;
        while (index < count) {
            byte type = gdipTypes[index];
            boolean close = false;
            switch (type & 7) {
                case 0: {
                    types[typesIndex++] = 1;
                    close = (type & 0x80) != 0;
                    ++index;
                    break;
                }
                case 1: {
                    types[typesIndex++] = 2;
                    close = (type & 0x80) != 0;
                    ++index;
                    break;
                }
                case 3: {
                    types[typesIndex++] = 4;
                    close = (gdipTypes[index + 2] & 0x80) != 0;
                    index += 3;
                    break;
                }
                default: {
                    ++index;
                }
            }
            if (!close) continue;
            types[typesIndex++] = 5;
        }
        if (typesIndex != types.length) {
            byte[] newTypes = new byte[typesIndex];
            System.arraycopy(types, 0, newTypes, 0, typesIndex);
            types = newTypes;
        }
        PathData result = new PathData();
        result.types = types;
        result.points = points;
        return result;
    }

    public void lineTo(float x, float y) {
        Device drawable = this.getDevice();
        this.lineToInPixels(DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom), DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom));
    }

    void lineToInPixels(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_AddLine(this.getHandle(this.initialZoom), this.currentPoint.X, this.currentPoint.Y, x, y);
        Gdip.GraphicsPath_GetLastPoint(this.getHandle(this.initialZoom), this.currentPoint);
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    @Override
    public boolean isDisposed() {
        return this.zoomLevelToHandle.isEmpty();
    }

    public void moveTo(float x, float y) {
        Device drawable = this.getDevice();
        this.moveToInPixels(DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom), DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom));
    }

    void moveToInPixels(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Gdip.GraphicsPath_StartFigure(this.getHandle(this.initialZoom));
        this.currentPoint.X = this.startPoint.X = x;
        this.currentPoint.Y = this.startPoint.Y = y;
    }

    public void quadTo(float cx, float cy, float x, float y) {
        Device drawable = this.getDevice();
        cx = DPIUtil.scaleUp((Drawable)drawable, cx, this.initialZoom);
        cy = DPIUtil.scaleUp((Drawable)drawable, cy, this.initialZoom);
        x = DPIUtil.scaleUp((Drawable)drawable, x, this.initialZoom);
        y = DPIUtil.scaleUp((Drawable)drawable, y, this.initialZoom);
        this.quadToInPixels(cx, cy, x, y);
    }

    void quadToInPixels(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        float cx1 = this.currentPoint.X + 2.0f * (cx - this.currentPoint.X) / 3.0f;
        float cy1 = this.currentPoint.Y + 2.0f * (cy - this.currentPoint.Y) / 3.0f;
        float cx2 = cx1 + (x - this.currentPoint.X) / 3.0f;
        float cy2 = cy1 + (y - this.currentPoint.Y) / 3.0f;
        Gdip.GraphicsPath_AddBezier(this.getHandle(this.initialZoom), this.currentPoint.X, this.currentPoint.Y, cx1, cy1, cx2, cy2, x, y);
        Gdip.GraphicsPath_GetLastPoint(this.getHandle(this.initialZoom), this.currentPoint);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path " + String.valueOf(this.zoomLevelToHandle);
    }

    long getHandle(int zoom) {
        if (!this.zoomLevelToHandle.containsKey(zoom)) {
            PathData pathData = this.getPathData();
            Path scaledPath = new Path(this.getDevice(), pathData, zoom);
            this.zoomLevelToHandle.put(zoom, scaledPath.getHandle(scaledPath.initialZoom));
        }
        return this.zoomLevelToHandle.get(zoom);
    }
}

