/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.server;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.server.JettyHelpServer;
import org.eclipse.help.server.HelpServer;

public class WebappManager {
    private static HelpServer server;
    private static final String SERVER_EXTENSION_ID = "org.eclipse.help.base.server";
    private static final String SERVER_CLASS_ATTRIBUTE = "class";

    private static HelpServer getHelpServer() {
        if (server == null) {
            WebappManager.createWebappServer();
        }
        if (server == null) {
            server = new JettyHelpServer();
        }
        return server;
    }

    public static void start(String webappName) throws Exception {
        WebappManager.getHelpServer().start(webappName);
    }

    public static void stop(String webappName) throws CoreException {
        WebappManager.getHelpServer().stop(webappName);
    }

    public static int getPort() {
        return WebappManager.getHelpServer().getPort();
    }

    public static String getHost() {
        return WebappManager.getHelpServer().getHost();
    }

    private static void createWebappServer() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(SERVER_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            if (elements.length == 0) {
                return;
            }
            IConfigurationElement serverElement = elements[0];
            try {
                server = (HelpServer)serverElement.createExecutableExtension(SERVER_CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                ILog.of(WebappManager.class).log(e.getStatus());
            }
        }
    }
}

