/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.findandreplace;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IFindReplaceTargetExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.findandreplace.FindReplaceMessages;
import org.eclipse.ui.internal.findandreplace.IFindReplaceLogic;
import org.eclipse.ui.internal.findandreplace.SearchOptions;
import org.eclipse.ui.internal.findandreplace.status.FindAllStatus;
import org.eclipse.ui.internal.findandreplace.status.FindStatus;
import org.eclipse.ui.internal.findandreplace.status.IFindReplaceStatus;
import org.eclipse.ui.internal.findandreplace.status.InvalidRegExStatus;
import org.eclipse.ui.internal.findandreplace.status.NoStatus;
import org.eclipse.ui.internal.findandreplace.status.ReplaceAllStatus;
import org.eclipse.ui.internal.texteditor.NLSUtility;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.IFindReplaceTargetExtension2;

public class FindReplaceLogic
implements IFindReplaceLogic {
    private IFindReplaceStatus status;
    private IFindReplaceTarget target;
    private Point incrementalBaseLocation;
    private boolean isTargetSupportingRegEx;
    private boolean isTargetEditable;
    private Set<SearchOptions> searchOptions = new HashSet<SearchOptions>();

    @Override
    public void activate(SearchOptions searchOption) {
        if (!this.searchOptions.add(searchOption)) {
            return;
        }
        switch (searchOption) {
            case GLOBAL: {
                this.unsetSearchScope();
                break;
            }
            case FORWARD: 
            case INCREMENTAL: {
                if (!this.shouldInitIncrementalBaseLocation()) break;
                this.initIncrementalBaseLocation();
                break;
            }
        }
    }

    @Override
    public void deactivate(SearchOptions searchOption) {
        if (!this.searchOptions.remove((Object)searchOption)) {
            return;
        }
        if (searchOption == SearchOptions.GLOBAL) {
            this.initializeSearchScope();
        }
        if (searchOption == SearchOptions.FORWARD && this.shouldInitIncrementalBaseLocation()) {
            this.initIncrementalBaseLocation();
        }
    }

    @Override
    public boolean isActive(SearchOptions searchOption) {
        return this.searchOptions.contains((Object)searchOption);
    }

    @Override
    public IFindReplaceStatus getStatus() {
        if (this.status == null) {
            return new NoStatus();
        }
        return this.status;
    }

    private void resetStatus() {
        this.status = null;
    }

    @Override
    public boolean isIncrementalSearchAvailable() {
        return !this.isRegExSearchAvailableAndActive();
    }

    @Override
    public boolean isWholeWordSearchAvailable(String findString) {
        return !this.isRegExSearchAvailableAndActive() && FindReplaceLogic.isWord(findString);
    }

    private static boolean isWord(String str) {
        return str != null && !str.isEmpty() && str.chars().allMatch(Character::isJavaIdentifierPart);
    }

    @Override
    public boolean isRegExSearchAvailableAndActive() {
        return this.isActive(SearchOptions.REGEX) && this.isTargetSupportingRegEx;
    }

    private void initIncrementalBaseLocation() {
        this.incrementalBaseLocation = this.target != null && this.isActive(SearchOptions.INCREMENTAL) && !this.isRegExSearchAvailableAndActive() ? this.target.getSelection() : new Point(0, 0);
    }

    public boolean shouldInitIncrementalBaseLocation() {
        return this.isActive(SearchOptions.INCREMENTAL) && !this.isActive(SearchOptions.REGEX);
    }

    private void initializeSearchScope() {
        if (this.shouldInitIncrementalBaseLocation()) {
            this.initIncrementalBaseLocation();
        }
        if (this.target == null || !(this.target instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.target;
        Point lineSelection = extensionTarget.getLineSelection();
        Region scope = new Region(lineSelection.x, lineSelection.y);
        int offset = this.isActive(SearchOptions.FORWARD) ? scope.getOffset() : scope.getOffset() + scope.getLength();
        extensionTarget.setSelection(offset, 0);
        extensionTarget.setScope((IRegion)scope);
    }

    private void unsetSearchScope() {
        if (this.target == null || !(this.target instanceof IFindReplaceTargetExtension)) {
            return;
        }
        IFindReplaceTargetExtension extensionTarget = (IFindReplaceTargetExtension)this.target;
        extensionTarget.setScope(null);
    }

    private IEditorStatusLine getStatusLineManager() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        return (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
    }

    @Override
    public void performReplaceAll(String findString, String replaceString) {
        this.resetStatus();
        if (findString != null && !findString.isEmpty()) {
            try {
                int replaceCount = this.replaceAll(findString, replaceString == null ? "" : replaceString);
                if (replaceCount != 0) {
                    if (replaceCount == 1) {
                        this.statusLineMessage(FindReplaceMessages.FindReplace_Status_replacement_label);
                    } else {
                        String msg = FindReplaceMessages.FindReplace_Status_replacements_label;
                        msg = NLSUtility.format(msg, String.valueOf(replaceCount));
                        this.statusLineMessage(msg);
                    }
                    this.status = new ReplaceAllStatus(replaceCount);
                } else {
                    String msg = NLSUtility.format(FindReplaceMessages.FindReplace_Status_noMatchWithValue_label, findString);
                    this.statusLineMessage(false, msg);
                    this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
                }
            }
            catch (PatternSyntaxException ex) {
                this.status = new InvalidRegExStatus(ex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    @Override
    public void performSelectAll(String findString) {
        this.resetStatus();
        if (findString != null && !findString.isEmpty()) {
            try {
                int selectCount = this.selectAll(findString);
                if (selectCount != 0) {
                    if (selectCount == 1) {
                        this.statusLineMessage(FindReplaceMessages.FindReplace_Status_selection_label);
                    } else {
                        String msg = FindReplaceMessages.FindReplace_Status_selections_label;
                        msg = NLSUtility.format(msg, String.valueOf(selectCount));
                        this.statusLineMessage(msg);
                    }
                    this.status = new FindAllStatus(selectCount);
                } else {
                    String msg = NLSUtility.format(FindReplaceMessages.FindReplace_Status_noMatchWithValue_label, findString);
                    this.statusLineMessage(false, msg);
                    this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
                }
            }
            catch (PatternSyntaxException ex) {
                this.status = new InvalidRegExStatus(ex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private boolean prepareTargetForEditing() {
        IFindReplaceTargetExtension2 extension;
        if (this.target instanceof IFindReplaceTargetExtension2 && !(extension = (IFindReplaceTargetExtension2)this.target).validateTargetState()) {
            this.status = new FindStatus(FindStatus.StatusCode.READONLY);
            return false;
        }
        return this.isEditable();
    }

    private boolean replaceSelection(String replaceString) {
        boolean replaced;
        if (!this.prepareTargetForEditing()) {
            return false;
        }
        if (replaceString == null) {
            replaceString = "";
        }
        try {
            this.replaceSelection(replaceString, this.isRegExSearchAvailableAndActive());
            replaced = true;
        }
        catch (PatternSyntaxException ex) {
            this.status = new InvalidRegExStatus(ex);
            replaced = false;
        }
        catch (IllegalStateException ex) {
            replaced = false;
        }
        return replaced;
    }

    @Override
    public boolean performSearch(String searchString) {
        return this.performSearch(this.shouldInitIncrementalBaseLocation(), searchString);
    }

    private boolean performSearch(boolean mustInitIncrementalBaseLocation, String findString) {
        if (mustInitIncrementalBaseLocation) {
            this.initIncrementalBaseLocation();
        }
        this.resetStatus();
        boolean somethingFound = false;
        if (findString != null && !findString.isEmpty()) {
            try {
                somethingFound = this.findNext(findString);
            }
            catch (PatternSyntaxException ex) {
                this.status = new InvalidRegExStatus(ex);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return somethingFound;
    }

    private int replaceAll(String findString, String replaceString) {
        if (!this.prepareTargetForEditing()) {
            return 0;
        }
        ArrayList replacements = new ArrayList();
        this.executeInForwardMode(() -> this.executeWithReplaceAllEnabled(() -> {
            Point currentSelection = new Point(0, 0);
            while (this.findAndSelect(currentSelection.x + currentSelection.y, findString) != -1) {
                currentSelection = this.replaceSelection(replaceString, this.isRegExSearchAvailableAndActive());
                replacements.add(currentSelection);
            }
        }));
        return replacements.size();
    }

    private void executeInForwardMode(Runnable runnable) {
        if (this.isActive(SearchOptions.FORWARD)) {
            runnable.run();
        } else {
            this.activate(SearchOptions.FORWARD);
            try {
                runnable.run();
            }
            finally {
                this.deactivate(SearchOptions.FORWARD);
            }
        }
    }

    private void executeWithReplaceAllEnabled(Runnable runnable) {
        IFindReplaceTarget iFindReplaceTarget = this.target;
        if (iFindReplaceTarget instanceof IFindReplaceTargetExtension) {
            IFindReplaceTargetExtension selectableTarget = (IFindReplaceTargetExtension)iFindReplaceTarget;
            selectableTarget.setReplaceAllMode(true);
            try {
                runnable.run();
            }
            finally {
                selectableTarget.setReplaceAllMode(false);
            }
        } else {
            runnable.run();
        }
    }

    private int selectAll(String findString) {
        ArrayList selections = new ArrayList();
        this.executeInForwardMode(() -> {
            Point currentSeletion = new Point(0, 0);
            while (this.findAndSelect(currentSeletion.x + currentSeletion.y, findString) != -1) {
                currentSeletion = this.target.getSelection();
                selections.add(currentSeletion);
            }
            IFindReplaceTarget iFindReplaceTarget = this.target;
            if (iFindReplaceTarget instanceof IFindReplaceTargetExtension4) {
                IFindReplaceTargetExtension4 selectableTarget = (IFindReplaceTargetExtension4)iFindReplaceTarget;
                IRegion[] selectedRegions = (IRegion[])selections.stream().map(selection -> new Region(selection.x, selection.y)).toArray(IRegion[]::new);
                selectableTarget.setSelection(selectedRegions);
            }
        });
        return selections.size();
    }

    private int findIndex(String findString, int startPosition) {
        int index = 0;
        if (this.isActive(SearchOptions.FORWARD)) {
            index = this.findAndSelect(startPosition, findString);
        } else {
            int n = index = startPosition == 0 ? -1 : this.findAndSelect(startPosition - 1, findString);
        }
        if (index == -1) {
            if (this.isActive(SearchOptions.WRAP)) {
                this.statusLineMessage(FindReplaceMessages.FindReplace_Status_wrapped_label);
                this.status = new FindStatus(FindStatus.StatusCode.WRAPPED);
                index = this.findAndSelect(-1, findString);
            } else {
                this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
            }
        }
        return index;
    }

    @Override
    public int findAndSelect(int offset, String findString) {
        boolean wholeWordSearch = this.isActive(SearchOptions.WHOLE_WORD) && this.isWholeWordSearchAvailable(findString);
        boolean forwardSearch = this.isActive(SearchOptions.FORWARD);
        boolean caseSensitiveSearch = this.isActive(SearchOptions.CASE_SENSITIVE);
        boolean regexSearch = this.isActive(SearchOptions.REGEX);
        IFindReplaceTarget iFindReplaceTarget = this.target;
        if (iFindReplaceTarget instanceof IFindReplaceTargetExtension3) {
            IFindReplaceTargetExtension3 regexSupportingTarget = (IFindReplaceTargetExtension3)iFindReplaceTarget;
            return regexSupportingTarget.findAndSelect(offset, findString, forwardSearch, caseSensitiveSearch, wholeWordSearch, regexSearch);
        }
        return this.target.findAndSelect(offset, findString, forwardSearch, caseSensitiveSearch, wholeWordSearch);
    }

    private Point replaceSelection(String replaceString, boolean regExReplace) {
        if (this.target instanceof IFindReplaceTargetExtension3) {
            ((IFindReplaceTargetExtension3)this.target).replaceSelection(replaceString, regExReplace);
        } else {
            this.target.replaceSelection(replaceString);
        }
        return this.target.getSelection();
    }

    private boolean findNext(String findString) {
        int index;
        if (this.target == null) {
            return false;
        }
        Point r = null;
        r = this.isActive(SearchOptions.INCREMENTAL) ? this.incrementalBaseLocation : this.target.getSelection();
        int findReplacePosition = r.x;
        if (this.isActive(SearchOptions.FORWARD)) {
            findReplacePosition += r.y;
        }
        if ((index = this.findIndex(findString, findReplacePosition)) == -1) {
            String msg = NLSUtility.format(FindReplaceMessages.FindReplace_Status_noMatchWithValue_label, findString);
            this.statusLineMessage(false, msg);
            this.status = new FindStatus(FindStatus.StatusCode.NO_MATCH);
            return false;
        }
        if (this.isActive(SearchOptions.FORWARD) && index >= findReplacePosition || !this.isActive(SearchOptions.FORWARD) && index <= findReplacePosition) {
            this.statusLineMessage("");
        }
        return true;
    }

    @Override
    public boolean performReplaceAndFind(String findString, String replaceString) {
        this.resetStatus();
        if (this.performSelectAndReplace(findString, replaceString)) {
            this.performSearch(findString);
            return true;
        }
        return false;
    }

    @Override
    public boolean performSelectAndReplace(String findString, String replaceString) {
        this.resetStatus();
        if (!this.isFindStringSelected(findString)) {
            this.performSearch(findString);
        }
        if (this.getStatus().wasSuccessful()) {
            return this.replaceSelection(replaceString);
        }
        return false;
    }

    private boolean isFindStringSelected(String findString) {
        String selectedString = this.getCurrentSelection();
        if (this.isRegExSearchAvailableAndActive()) {
            int patternFlags = 0;
            if (!this.isActive(SearchOptions.CASE_SENSITIVE)) {
                patternFlags |= 0x42;
            }
            Pattern pattern = Pattern.compile(findString, patternFlags);
            return pattern.matcher(selectedString).find();
        }
        return this.getCurrentSelection().equals(findString);
    }

    @Override
    public void updateTarget(IFindReplaceTarget newTarget, boolean canEditTarget) {
        this.resetStatus();
        this.isTargetEditable = canEditTarget;
        if (this.target != newTarget) {
            if (this.target instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)this.target).endSession();
            }
            this.target = newTarget;
            this.isTargetSupportingRegEx = newTarget instanceof IFindReplaceTargetExtension3;
            if (newTarget instanceof IFindReplaceTargetExtension) {
                ((IFindReplaceTargetExtension)newTarget).beginSession();
                this.activate(SearchOptions.GLOBAL);
            }
        }
        this.initIncrementalBaseLocation();
    }

    @Override
    public void dispose() {
        if (this.target != null && this.target instanceof IFindReplaceTargetExtension) {
            ((IFindReplaceTargetExtension)this.target).endSession();
        }
        this.target = null;
    }

    private String getCurrentSelection() {
        if (this.target == null) {
            return null;
        }
        return this.target.getSelectionText();
    }

    private boolean isEditable() {
        boolean isEditable;
        boolean bl = isEditable = this.target == null ? false : this.target.isEditable();
        return this.isTargetEditable && isEditable;
    }

    private void statusLineMessage(boolean error, String editorMessage) {
        IEditorStatusLine statusLine = this.getStatusLineManager();
        if (statusLine != null) {
            statusLine.setMessage(error, editorMessage, null);
        }
    }

    private void statusLineMessage(String message) {
        this.statusLineMessage(false, message);
    }

    @Override
    public void performIncrementalSearch(String searchString) {
        this.resetStatus();
        if (this.isActive(SearchOptions.INCREMENTAL) && this.isIncrementalSearchAvailable()) {
            if (searchString.equals("") && this.target != null) {
                int offset = this.incrementalBaseLocation.x;
                if (this.isActive(SearchOptions.FORWARD)) {
                    offset += this.incrementalBaseLocation.y;
                }
                this.findAndSelect(offset, "");
            } else {
                this.performSearch(false, searchString);
            }
        }
    }

    @Override
    public IFindReplaceTarget getTarget() {
        return this.target;
    }
}

