/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.timing.core.tests.segmentstore;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.eclipse.tracecompass.analysis.timing.core.tests.stubs.segmentstore.StubSegmentStoreOnDiskProvider;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStub;
import org.eclipse.tracecompass.tmf.tests.stubs.trace.xml.TmfXmlTraceStubNs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SegmentStoreAnalysisTest {
    private static TmfXmlTraceStub fTrace;

    @BeforeClass
    public static void init() {
        TmfXmlTraceStubNs trace = new TmfXmlTraceStubNs();
        Assert.assertNotNull((Object)trace);
        fTrace = trace;
    }

    @AfterClass
    public static void tearDown() {
        fTrace.dispose();
    }

    @Test
    public void testClearPersistentData() throws TmfAnalysisException {
        StubSegmentStoreOnDiskProvider module = new StubSegmentStoreOnDiskProvider();
        StubSegmentStoreOnDiskProvider module2 = new StubSegmentStoreOnDiskProvider();
        try {
            TmfXmlTraceStub trace = fTrace;
            Assert.assertNotNull((Object)trace);
            module.setTrace((ITmfTrace)trace);
            module2.setTrace((ITmfTrace)trace);
            module.schedule();
            Assert.assertTrue((boolean)module.waitForCompletion());
            Assert.assertTrue((boolean)Files.exists(module.getDataFilePath(), new LinkOption[0]));
            module.clearPersistentData();
            Path dataFile = module.getDataFilePath();
            Assert.assertNotNull((Object)dataFile);
            Assert.assertFalse((boolean)Files.exists(dataFile, new LinkOption[0]));
            module.schedule();
            Assert.assertTrue((boolean)module.waitForCompletion());
            module.dispose();
            module2.clearPersistentData();
            dataFile = module.getDataFilePath();
            Assert.assertNotNull((Object)dataFile);
            Assert.assertFalse((boolean)Files.exists(dataFile, new LinkOption[0]));
        }
        finally {
            module.dispose();
            module2.dispose();
        }
    }
}

