/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.internal.DPIUtil;

class ImageDataLoader {
    ImageDataLoader() {
    }

    public static ImageData load(InputStream stream) {
        ImageData[] data = new ImageLoader().load(stream);
        if (data.length < 1) {
            SWT.error(40);
        }
        return data[0];
    }

    public static ImageData load(String filename) {
        ImageData[] data = new ImageLoader().load(filename);
        if (data.length < 1) {
            SWT.error(40);
        }
        return data[0];
    }

    public static boolean canLoadAtZoom(InputStream stream, int fileZoom, int targetZoom) {
        return ImageLoader.canLoadAtZoom(stream, fileZoom, targetZoom);
    }

    public static boolean canLoadAtZoom(String filename, int fileZoom, int targetZoom) {
        return ImageLoader.canLoadAtZoom(filename, fileZoom, targetZoom);
    }

    static boolean isDynamicallySizable(String filename) {
        return ImageLoader.isDynamicallySizable(filename);
    }

    static boolean isDynamicallySizable(InputStream stream) {
        return ImageLoader.isDynamicallySizable(stream);
    }

    public static DPIUtil.ElementAtZoom<ImageData> loadByZoom(InputStream stream, int fileZoom, int targetZoom) {
        List<DPIUtil.ElementAtZoom<ImageData>> data = new ImageLoader().loadByZoom(stream, fileZoom, targetZoom);
        if (data.isEmpty()) {
            SWT.error(40);
        }
        return data.get(0);
    }

    public static DPIUtil.ElementAtZoom<ImageData> loadByZoom(String filename, int fileZoom, int targetZoom) {
        List<DPIUtil.ElementAtZoom<ImageData>> data = new ImageLoader().loadByZoom(filename, fileZoom, targetZoom);
        if (data.isEmpty()) {
            SWT.error(40);
        }
        return data.get(0);
    }

    public static ImageData loadBySize(InputStream stream, int width, int height) {
        ImageData data = new ImageLoader().loadBySize(stream, width, height);
        if (data == null) {
            SWT.error(40);
        }
        return data;
    }

    public static ImageData loadBySize(String filename, int width, int height) {
        ImageData data = new ImageLoader().loadBySize(filename, width, height);
        if (data == null) {
            SWT.error(40);
        }
        return data;
    }
}

