/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.core;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.wst.common.uriresolver.URIHelper;

public class LazyURLInputStream
extends InputStream {
    protected InputStream inner;
    protected String url;
    protected boolean error;
    boolean hasMarks;
    boolean pretendFileIsStillOpen;

    public LazyURLInputStream(String url) {
        this.url = url;
        this.inner = null;
        this.pretendFileIsStillOpen = false;
    }

    private void createInnerStreamIfRequired() throws IOException {
        if (this.inner == null && !this.error) {
            try {
                this.inner = URIHelper.getInputStream((String)this.url, (int)0);
                this.pretendFileIsStillOpen = false;
                this.hasMarks = false;
            }
            finally {
                if (this.inner == null) {
                    this.error = true;
                }
            }
        }
    }

    protected void closeStream() throws IOException {
        if (this.inner != null && !this.pretendFileIsStillOpen) {
            this.inner.close();
            this.pretendFileIsStillOpen = true;
        }
    }

    @Override
    public int available() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return 0;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        return this.inner.available();
    }

    @Override
    public void close() throws IOException {
        if (this.pretendFileIsStillOpen) {
            this.pretendFileIsStillOpen = false;
        } else if (this.inner != null) {
            this.inner.close();
        }
    }

    @Override
    public void mark(int readlimit) {
        if (this.pretendFileIsStillOpen) {
            return;
        }
        this.hasMarks = true;
        try {
            this.createInnerStreamIfRequired();
            this.inner.mark(readlimit);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean markSupported() {
        block4: {
            if (this.pretendFileIsStillOpen) {
                return false;
            }
            try {
                this.createInnerStreamIfRequired();
                if (this.inner != null) break block4;
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return this.inner.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read();
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read(b);
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return -1;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        int bytesRead = this.inner.read(b, off, len);
        if (bytesRead == -1 && !this.hasMarks) {
            this.closeStream();
        }
        return bytesRead;
    }

    @Override
    public void reset() throws IOException {
        if (this.pretendFileIsStillOpen) {
            return;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        this.inner.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.pretendFileIsStillOpen) {
            return 0L;
        }
        this.createInnerStreamIfRequired();
        if (this.inner == null) {
            throw new IOException("Stream not available");
        }
        return this.inner.skip(n);
    }
}

