/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.formatter;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.formatter.CodeFormatter;
import org.eclipse.cdt.core.formatter.DefaultCodeFormatterOptions;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.ParserUtil;
import org.eclipse.cdt.core.parser.ScannerInfo;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.util.TextUtil;
import org.eclipse.cdt.internal.formatter.AbortFormatting;
import org.eclipse.cdt.internal.formatter.CodeFormatterVisitor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.TextEdit;

public class CCodeFormatter
extends CodeFormatter {
    private DefaultCodeFormatterOptions preferences;
    private Map<String, ?> options;

    public CCodeFormatter() {
        this(DefaultCodeFormatterOptions.getDefaultSettings());
    }

    public CCodeFormatter(DefaultCodeFormatterOptions preferences) {
        this(preferences, null);
    }

    public CCodeFormatter(DefaultCodeFormatterOptions defaultCodeFormatterOptions, Map<String, ?> options) {
        this.setOptions(options);
        if (defaultCodeFormatterOptions != null) {
            this.preferences.set(defaultCodeFormatterOptions.getMap());
        }
    }

    public CCodeFormatter(Map<String, ?> options) {
        this(null, options);
    }

    @Override
    public String createIndentationString(int indentationLevel) {
        if (indentationLevel < 0) {
            throw new IllegalArgumentException();
        }
        int tabs = 0;
        int spaces = 0;
        switch (this.preferences.tab_char) {
            case 2: {
                spaces = indentationLevel * this.preferences.tab_size;
                break;
            }
            case 1: {
                tabs = indentationLevel;
                break;
            }
            case 4: {
                int tabSize = this.preferences.tab_size;
                int spaceEquivalents = indentationLevel * this.preferences.indentation_size;
                tabs = spaceEquivalents / tabSize;
                spaces = spaceEquivalents % tabSize;
                break;
            }
            default: {
                return "";
            }
        }
        if (tabs == 0 && spaces == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(tabs + spaces);
        int i = 0;
        while (i < tabs) {
            buffer.append('\t');
            ++i;
        }
        i = 0;
        while (i < spaces) {
            buffer.append(' ');
            ++i;
        }
        return buffer.toString();
    }

    @Override
    public void setOptions(Map<String, ?> options) {
        if (options != null) {
            this.options = options;
            HashMap<String, String> formatterPrefs = new HashMap<String, String>(options.size());
            for (String key : options.keySet()) {
                Object value = options.get(key);
                if (!(value instanceof String)) continue;
                formatterPrefs.put(key, (String)value);
            }
            this.preferences = new DefaultCodeFormatterOptions(formatterPrefs);
        } else {
            this.options = CCorePlugin.getOptions();
            this.preferences = DefaultCodeFormatterOptions.getDefaultSettings();
        }
    }

    @Override
    public TextEdit format(int kind, String source, int offset, int length, int indentationLevel, String lineSeparator) {
        this.preferences.initial_indentation_level = indentationLevel;
        return this.format(kind, source, new IRegion[]{new Region(offset, length)}, lineSeparator)[0];
    }

    @Override
    public TextEdit[] format(int kind, String source, IRegion[] regions, String lineSeparator) {
        TextEdit[] edits = new TextEdit[regions.length];
        this.preferences.line_separator = lineSeparator != null ? lineSeparator : System.getProperty("line.separator");
        ITranslationUnit tu = this.getTranslationUnit(source);
        if (tu != null) {
            IIndex index;
            try {
                index = CCorePlugin.getIndexManager().getIndex(tu.getCProject());
                index.acquireReadLock();
            }
            catch (CoreException e) {
                throw new AbortFormatting(e);
            }
            catch (InterruptedException e) {
                return null;
            }
            try {
                IASTTranslationUnit ast;
                try {
                    ast = tu.getAST(index, 2);
                }
                catch (CoreException e) {
                    throw new AbortFormatting(e);
                }
                if (ast == null) {
                    throw new AbortFormatting("AST is null");
                }
                this.formatRegions(source, regions, edits, ast);
            }
            finally {
                index.releaseReadLock();
            }
        }
        IncludeFileContentProvider contentProvider = IncludeFileContentProvider.getSavedFilesProvider();
        ScannerInfo scanInfo = new ScannerInfo();
        FileContent content = FileContent.create("<text>", source.toCharArray());
        ILanguage language = (ILanguage)this.options.get("org.eclipse.cdt.core.formatter.language");
        if (language == null) {
            language = GPPLanguage.getDefault();
        }
        try {
            IASTTranslationUnit ast = language.getASTTranslationUnit(content, (IScannerInfo)scanInfo, contentProvider, null, 0, ParserUtil.getParserLogService());
            this.formatRegions(source, regions, edits, ast);
        }
        catch (CoreException e) {
            throw new AbortFormatting(e);
        }
        return edits;
    }

    private void formatRegions(String source, IRegion[] regions, TextEdit[] edits, IASTTranslationUnit ast) {
        int i = 0;
        while (i < regions.length) {
            IRegion region = regions[i];
            if (this.shouldFormatWholeStatements()) {
                region = this.getLineOrStatementRegion(source, region, ast);
            }
            CodeFormatterVisitor codeFormatter = new CodeFormatterVisitor(this.preferences, region.getOffset(), region.getLength());
            edits[i] = codeFormatter.format(source, ast);
            IStatus status = codeFormatter.getStatus();
            if (!status.isOK()) {
                CCorePlugin.log(status);
            }
            ++i;
        }
    }

    private boolean shouldFormatWholeStatements() {
        Object obj = this.options.get("org.eclipse.cdt.core.formatter.statement_scope");
        return obj instanceof Boolean && (Boolean)obj != false;
    }

    private IRegion getLineOrStatementRegion(String source, IRegion region, IASTTranslationUnit ast) {
        int end;
        int start = TextUtil.getLineStart(source, region.getOffset());
        IASTNode node = this.findOverlappingPreprocessorStatement(start, end = TextUtil.skipToNextLine(source, region.getOffset() + region.getLength()), ast);
        if (node != null) {
            int nodeEnd;
            IASTFileLocation location = node.getFileLocation();
            int nodeOffset = location.getNodeOffset();
            if (nodeOffset < start) {
                start = nodeOffset;
            }
            if ((nodeEnd = nodeOffset + location.getNodeLength()) > end) {
                end = nodeEnd;
            }
            return new Region(start, end - start);
        }
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        int pos = start;
        while (pos < end) {
            int nodeEnd;
            node = nodeSelector.findFirstContainedNode(pos, end - pos);
            if (node != null) {
                IASTNode containedNode = node;
                if ((node = ASTQueries.findAncestorWithType(containedNode, IASTStatement.class)) == null) {
                    node = ASTQueries.findAncestorWithType(containedNode, IASTDeclaration.class);
                }
                if (node == null) {
                    node = ASTQueries.findAncestorWithType(containedNode, IASTPreprocessorMacroExpansion.class);
                }
            }
            if (node == null) break;
            IASTFileLocation location = node.getFileLocation();
            int nodeOffset = location.getNodeOffset();
            if (nodeOffset < start) {
                start = nodeOffset;
            }
            if ((nodeEnd = nodeOffset + location.getNodeLength()) > end) {
                end = nodeEnd;
            }
            pos = nodeEnd;
        }
        return new Region(start, end - start);
    }

    private IASTNode findOverlappingPreprocessorStatement(int start, int end, IASTTranslationUnit ast) {
        IASTPreprocessorStatement[] statements = ast.getAllPreprocessorStatements();
        int low = 0;
        int high = statements.length;
        while (low < high) {
            int mid = low + high >>> 1;
            IASTPreprocessorStatement statement = statements[mid];
            IASTFileLocation location = statement.getFileLocation();
            if (location == null) {
                low = mid + 1;
                continue;
            }
            int statementOffset = location.getNodeOffset();
            if (statementOffset >= end) {
                high = mid;
                continue;
            }
            if (statementOffset + location.getNodeLength() <= start) {
                low = mid + 1;
                continue;
            }
            return statement;
        }
        return null;
    }

    private ITranslationUnit getTranslationUnit(String source) {
        IFile file;
        ITranslationUnit tu = (ITranslationUnit)this.options.get("org.eclipse.cdt.core.formatter.current_translation_unit");
        if (tu == null && (file = (IFile)this.options.get("org.eclipse.cdt.core.formatter.current_file")) != null) {
            tu = (ITranslationUnit)CoreModel.getDefault().create(file);
        }
        if (tu != null && source != null) {
            try {
                if (tu.isWorkingCopy()) {
                    tu = ((IWorkingCopy)tu).getOriginalElement();
                }
                tu = tu.getWorkingCopy();
                tu.getBuffer().setContents(source);
            }
            catch (CModelException e) {
                throw new AbortFormatting((Throwable)((Object)e));
            }
        }
        return tu;
    }
}

