/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.core.commands;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.IOException;
import java.text.MessageFormat;
import java.text.StringCharacterIterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.remote.core.RemoteServicesUtils;
import org.eclipse.remote.core.exception.RemoteConnectionException;
import org.eclipse.remote.internal.jsch.core.JSchConnection;
import org.eclipse.remote.internal.jsch.core.messages.Messages;

public abstract class AbstractRemoteCommand<T> {
    private static ExecutorService fPool = Executors.newSingleThreadExecutor();
    private final JSchConnection fConnection;
    public static final int UNKNOWN = 0;
    public static final int SUCCESS_OK = 1;
    public static final int SUCCESS_ERROR = 2;
    public static final int ERROR_NOT_EXECUTABLE = 126;
    public static final int ERROR_NOT_FOUND = 127;
    public static final int INVALID_EXIT_CODE = 128;
    public static final int SIGHUP = 129;
    public static final int SIGINT = 130;
    public static final int SIGQUIT = 131;
    public static final int SIGILL = 132;
    public static final int SIGTRAP = 133;
    public static final int SIGIOT = 134;
    public static final int SIGBUS = 135;
    public static final int SIGFPE = 136;
    public static final int SIGKILL = 137;
    public static final int SIGUSR1 = 138;
    public static final int SIGSEGV = 139;
    public static final int SIGUSR2 = 140;
    public static final int SIGPIPE = 141;
    public static final int SIGALRM = 142;
    public static final int SIGTERM = 143;
    public static final int SIGSTKFLT = 144;
    public static final int SIGCHLD = 145;
    public static final int SIGCONT = 146;
    public static final int SIGSTOP = 147;
    public static final int SIGTSTP = 148;
    public static final int SIGTTIN = 149;
    public static final int SIGTTOU = 150;
    public static final int SIGURG = 151;
    public static final int SIGXCPU = 152;
    public static final int SIGXFSZ = 153;
    public static final int SIGVTALRM = 154;
    public static final int SIGPROF = 155;
    public static final int SIGWINCH = 156;
    public static final int SIGIO = 157;
    public static final int SIGPWR = 158;

    public AbstractRemoteCommand(JSchConnection connection) {
        this.fConnection = connection;
    }

    protected IFileInfo convertToFileInfo(IPath path, SftpATTRS attrs, IProgressMonitor monitor) throws RemoteConnectionException {
        return this.convertToFileInfo(path.lastSegment(), path.removeLastSegments(1), attrs, monitor);
    }

    protected IFileInfo convertToFileInfo(final String name, final IPath parentPath, SftpATTRS attrs, IProgressMonitor monitor) throws RemoteConnectionException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        FileInfo fileInfo = new FileInfo(name);
        fileInfo.setExists(true);
        fileInfo.setDirectory(attrs.isDir());
        fileInfo.setAttribute(0x1000000, (attrs.getPermissions() & 0x40) != 0);
        fileInfo.setAttribute(0x800000, (attrs.getPermissions() & 0x80) != 0);
        fileInfo.setAttribute(0x400000, (attrs.getPermissions() & 0x100) != 0);
        fileInfo.setAttribute(0x8000000, (attrs.getPermissions() & 8) != 0);
        fileInfo.setAttribute(0x4000000, (attrs.getPermissions() & 0x10) != 0);
        fileInfo.setAttribute(0x2000000, (attrs.getPermissions() & 0x20) != 0);
        fileInfo.setAttribute(0x40000000, (attrs.getPermissions() & 1) != 0);
        fileInfo.setAttribute(0x20000000, (attrs.getPermissions() & 2) != 0);
        fileInfo.setAttribute(0x10000000, (attrs.getPermissions() & 4) != 0);
        fileInfo.setAttribute(32, attrs.isLink());
        if (attrs.isLink()) {
            SftpCallable<String> c2 = new SftpCallable<String>(this){

                @Override
                public String call() throws JSchException, SftpException {
                    return this.getChannel().readlink(parentPath.append(name).toString());
                }
            };
            try {
                progress.subTask(Messages.AbstractRemoteCommand_Get_symlink_target);
                String target = (String)c2.getResult((IProgressMonitor)progress.newChild(10));
                fileInfo.setStringAttribute(64, target);
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        }
        fileInfo.setLastModified((long)attrs.getMTime() * 1000L);
        fileInfo.setLength(attrs.getSize());
        return fileInfo;
    }

    public JSchConnection getConnection() {
        return this.fConnection;
    }

    public int getFinishStatus() {
        int code = 0;
        if (code == 0) {
            return 1;
        }
        if (code <= 125) {
            return 2;
        }
        if (code == 126) {
            return 126;
        }
        if (code == 127) {
            return 127;
        }
        if (code == 128) {
            return 0;
        }
        if (code == 255) {
            return 128;
        }
        if (code == 129) {
            return 129;
        }
        if (code == 130) {
            return 130;
        }
        if (code == 131) {
            return 131;
        }
        if (code == 132) {
            return 132;
        }
        if (code == 133) {
            return 133;
        }
        if (code == 134) {
            return 134;
        }
        if (code == 135) {
            return 135;
        }
        if (code == 136) {
            return 136;
        }
        if (code == 137) {
            return 137;
        }
        if (code == 138) {
            return 138;
        }
        if (code == 139) {
            return 139;
        }
        if (code == 140) {
            return 140;
        }
        if (code == 141) {
            return 141;
        }
        if (code == 142) {
            return 142;
        }
        if (code == 143) {
            return 143;
        }
        if (code == 144) {
            return 144;
        }
        if (code == 145) {
            return 145;
        }
        if (code == 146) {
            return 146;
        }
        if (code == 147) {
            return 147;
        }
        if (code == 148) {
            return 148;
        }
        if (code == 149) {
            return 149;
        }
        if (code == 150) {
            return 150;
        }
        if (code == 151) {
            return 151;
        }
        if (code == 152) {
            return 152;
        }
        if (code == 153) {
            return 153;
        }
        if (code == 154) {
            return 154;
        }
        if (code == 155) {
            return 155;
        }
        if (code == 156) {
            return 156;
        }
        if (code == 157) {
            return 157;
        }
        if (code == 158) {
            return 158;
        }
        return 0;
    }

    protected abstract T getResult(IProgressMonitor var1) throws RemoteConnectionException;

    protected String quote(String path, boolean full) {
        StringBuffer buffer = new StringBuffer();
        StringCharacterIterator iter = new StringCharacterIterator(path);
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case '\n': 
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case ':': 
                case ';': 
                case '<': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    if (full) {
                        buffer.append('\\');
                    }
                    buffer.append(c);
                    break;
                }
                case ' ': {
                    buffer.append('\\');
                    buffer.append(c);
                    break;
                }
                default: {
                    buffer.append(c);
                }
            }
            c = iter.next();
        }
        return buffer.toString();
    }

    protected static class CommandProgressMonitor
    implements SftpProgressMonitor {
        private final IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWork;
        private String fMaxWorkSize;
        private long fWorkToDate;
        private String fPrefix;

        public CommandProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public CommandProgressMonitor(String prefix, IProgressMonitor monitor) {
            this.fPrefix = prefix;
            this.fMonitor = monitor;
        }

        public boolean count(long count) {
            Long workToDate;
            String size;
            this.fWorkToDate += count;
            if (this.fWorkToDate < 1024L) {
                size = "bytes";
                workToDate = this.fWorkToDate;
            } else {
                size = "KB";
                workToDate = this.fWorkToDate / 1024L;
            }
            StringBuffer taskName = new StringBuffer();
            if (this.fPrefix != null) {
                taskName.append(this.fPrefix);
            }
            if (this.fWorkPercentFactor < 0.0) {
                taskName.append(MessageFormat.format(Messages.AbstractRemoteCommand_format1, workToDate, size));
            } else {
                Double workPercent = this.fWorkPercentFactor * (double)this.fWorkToDate;
                taskName.append(MessageFormat.format(Messages.AbstractRemoteCommand_format2, workToDate, size, this.fMaxWork, this.fMaxWorkSize, workPercent));
            }
            this.fMonitor.subTask(taskName.toString());
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void end() {
            this.fMonitor.done();
        }

        public void init(int op, String src, String dest, long max) {
            this.fWorkPercentFactor = 1.0 / (double)max;
            if (max < 1024L) {
                this.fMaxWorkSize = "bytes";
                this.fMaxWork = max;
            } else {
                this.fMaxWorkSize = "KB";
                this.fMaxWork = max / 1024L;
            }
            this.fWorkToDate = 0L;
            this.fMonitor.beginTask(RemoteServicesUtils.posixPath((String)src).lastSegment(), (int)max);
        }
    }

    protected abstract class ExecCallable<T1>
    implements Callable<T1> {
        private IProgressMonitor fProgressMonitor;
        private ChannelExec fExecChannel;

        protected ExecCallable() {
        }

        private Future<T1> asyncCmdInThread() throws RemoteConnectionException {
            this.setChannel(AbstractRemoteCommand.this.fConnection.getExecChannel());
            return fPool.submit(this);
        }

        @Override
        public abstract T1 call() throws JSchException, IOException, RemoteConnectionException;

        private void finalizeCmdInThread() {
            this.setChannel(null);
        }

        public ChannelExec getChannel() {
            return this.fExecChannel;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public T1 getResult(IProgressMonitor monitor) throws RemoteConnectionException {
            Future<T1> future = null;
            this.fProgressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                future = this.asyncCmdInThread();
                T1 T1 = this.waitCmdInThread(future);
                return T1;
            }
            finally {
                this.finalizeCmdInThread();
            }
        }

        public void setChannel(ChannelExec channel) {
            this.fExecChannel = channel;
        }

        private T1 waitCmdInThread(Future<T1> future) throws RemoteConnectionException {
            boolean bInterrupted = Thread.interrupted();
            while (!this.getProgressMonitor().isCanceled()) {
                try {
                    return future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    bInterrupted = true;
                }
                catch (TimeoutException e) {
                }
                catch (ExecutionException e) {
                    this.getChannel().disconnect();
                    throw new RemoteConnectionException(e.getMessage());
                }
                this.getProgressMonitor().worked(1);
            }
            if (bInterrupted) {
                Thread.currentThread().interrupt();
            }
            future.cancel(true);
            this.getChannel().disconnect();
            throw new RemoteConnectionException(Messages.AbstractRemoteCommand_Operation_cancelled_by_user);
        }
    }

    protected abstract class SftpCallable<T1>
    implements Callable<T1> {
        private IProgressMonitor fProgressMonitor;
        private ChannelSftp fSftpChannel;

        protected SftpCallable() {
        }

        private Future<T1> asyncCmdInThread() throws RemoteConnectionException {
            this.setChannel(AbstractRemoteCommand.this.fConnection.getSftpCommandChannel());
            return fPool.submit(this);
        }

        @Override
        public abstract T1 call() throws JSchException, SftpException, IOException;

        private void finalizeCmdInThread() {
            this.setChannel(null);
        }

        public ChannelSftp getChannel() {
            return this.fSftpChannel;
        }

        public IProgressMonitor getProgressMonitor() {
            return this.fProgressMonitor;
        }

        public T1 getResult(IProgressMonitor monitor) throws SftpException, RemoteConnectionException {
            Future<T1> future = null;
            this.fProgressMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            try {
                future = this.asyncCmdInThread();
                T1 T1 = this.waitCmdInThread(future);
                return T1;
            }
            finally {
                this.finalizeCmdInThread();
            }
        }

        public void setChannel(ChannelSftp channel) {
            this.fSftpChannel = channel;
        }

        private T1 waitCmdInThread(Future<T1> future) throws SftpException, RemoteConnectionException {
            boolean bInterrupted = Thread.interrupted();
            while (!this.getProgressMonitor().isCanceled()) {
                try {
                    return future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    bInterrupted = true;
                }
                catch (TimeoutException e) {
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof SftpException) {
                        throw (SftpException)e.getCause();
                    }
                    throw new RemoteConnectionException(e.getMessage());
                }
                this.getProgressMonitor().worked(1);
            }
            if (bInterrupted) {
                Thread.currentThread().interrupt();
            }
            future.cancel(true);
            throw new RemoteConnectionException(Messages.AbstractRemoteCommand_Operation_cancelled_by_user);
        }
    }
}

