/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.model;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.service.prefs.Preferences;

class PrefUtil {
    static long WAIT_INTERVAL_MS = 500L;
    static int WAIT_DELAY = PrefUtil.getInt("org.eclipse.wst.sse.core.modelmanager.maxWaitDuringConcurrentLoad");
    static boolean ALLOW_INTERRUPT_WAITING_THREAD = PrefUtil.getBoolean("org.eclipse.wst.sse.core.modelmanager.allowInterruptsDuringConcurrentLoad");
    private static final long MILLI_ORIGIN = System.currentTimeMillis();
    private static IEclipsePreferences.IPreferenceChangeListener LISTENER;

    static {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences instancePrefs = scope.getNode("org.eclipse.wst.sse.core");
        LISTENER = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if ("modelmanager.maxWaitDuringConcurrentLoad".equals(event.getKey())) {
                    WAIT_DELAY = PrefUtil.getInt("org.eclipse.wst.sse.core.modelmanager.maxWaitDuringConcurrentLoad");
                } else if ("modelmanager.allowInterruptsDuringConcurrentLoad".equals(event.getKey())) {
                    ALLOW_INTERRUPT_WAITING_THREAD = PrefUtil.getBoolean("org.eclipse.wst.sse.core.modelmanager.allowInterruptsDuringConcurrentLoad");
                }
            }
        };
        instancePrefs.addPreferenceChangeListener(LISTENER);
    }

    PrefUtil() {
    }

    static final long now() {
        return System.currentTimeMillis() - MILLI_ORIGIN;
    }

    private static String getProperty(String property) {
        String value = null;
        if (value == null) {
            value = System.getenv(property);
        }
        if (value == null) {
            value = System.getProperty(property);
        }
        if (value == null) {
            IPreferencesService preferencesService = Platform.getPreferencesService();
            String key = property;
            if (property != null && property.startsWith("org.eclipse.wst.sse.core")) {
                key = property.substring("org.eclipse.wst.sse.core".length() + 1, property.length());
            }
            InstanceScope instance = new InstanceScope();
            ConfigurationScope config = new ConfigurationScope();
            IEclipsePreferences instanceNode = instance.getNode("org.eclipse.wst.sse.core");
            IEclipsePreferences configNode = config.getNode("org.eclipse.wst.sse.core");
            value = preferencesService.get(key, PrefUtil.getDefault(property), new Preferences[]{configNode, instanceNode});
        }
        return value;
    }

    private static String getDefault(String property) {
        if ("org.eclipse.wst.sse.core.modelmanager.maxWaitDuringConcurrentLoad".equals(property)) {
            return "0";
        }
        if ("org.eclipse.wst.sse.core.modelmanager.allowInterruptsDuringConcurrentLoad".equals(property)) {
            return "false";
        }
        return null;
    }

    private static boolean getBoolean(String key) {
        String property = PrefUtil.getProperty(key);
        return property != null ? Boolean.valueOf(property) : Boolean.valueOf(PrefUtil.getDefault(key));
    }

    private static int getInt(String key) {
        String property = PrefUtil.getProperty(key);
        int size = 0;
        if (property != null) {
            try {
                size = Integer.parseInt(property);
            }
            catch (NumberFormatException numberFormatException) {
                size = PrefUtil.getDefaultInt(key, property, size);
            }
        } else {
            size = PrefUtil.getDefaultInt(key, property, size);
        }
        return size;
    }

    private static int getDefaultInt(String key, String property, int size) {
        try {
            size = Integer.parseInt(PrefUtil.getDefault(key));
        }
        catch (NumberFormatException e1) {
            PrefUtil.handleIntParseException(key, property, e1);
            size = 0;
        }
        return size;
    }

    private static void handleIntParseException(String key, String property, NumberFormatException e1) {
        Exception n = new Exception(NLS.bind((String)"Exception during parse of default value for key ''{0}'' value was ''{1}''. Using 0 instead", (Object)key, (Object)property), e1);
        n.printStackTrace();
    }
}

