/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.model.xy;

import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.Messages;
import org.eclipse.tracecompass.tmf.core.model.ISampling;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfXYAxisDescription;

public interface ISeriesModel {
    public long getId();

    public String getName();

    default public TmfXYAxisDescription getXAxisDescription() {
        return new TmfXYAxisDescription(NonNullUtils.nullToEmptyString((Object)Messages.TmfCoreModelXy_xAxisLabel), "");
    }

    default public TmfXYAxisDescription getYAxisDescription() {
        return new TmfXYAxisDescription(NonNullUtils.nullToEmptyString((Object)Messages.TmfCoreModelXy_yAxisLabel), "");
    }

    default public DisplayType getDisplayType() {
        return DisplayType.LINE;
    }

    @Deprecated(since="10.1", forRemoval=true)
    public long[] getXAxis();

    default public ISampling getSampling() {
        long[] legacy = this.getXAxis();
        return new ISampling.Timestamps(legacy);
    }

    public double[] getData();

    default public int[] getProperties() {
        return new int[this.getXAxis().length];
    }

    public static enum DisplayType {
        LINE,
        SCATTER,
        BAR;

    }
}

