/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.config;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;
import org.eclipse.tracecompass.tmf.core.config.ITmfConfiguration;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfConfigurationException;

public class TmfConfiguration
implements ITmfConfiguration {
    public static final String UNKNOWN = "---unknown---";
    public static final String JSON_EXTENSION = "json";
    @Expose
    @SerializedName(value="id")
    private @Nullable String fId;
    @Expose
    @SerializedName(value="name")
    private final @Nullable String fName;
    @Expose
    @SerializedName(value="description")
    private final @Nullable String fDescription;
    @Expose
    @SerializedName(value="sourceTypeId")
    private @Nullable String fSourceTypeId;
    @Expose
    @SerializedName(value="parameters")
    private final @Nullable Map<String, Object> fParameters;

    public TmfConfiguration() {
        this.fId = UNKNOWN;
        this.fName = UNKNOWN;
        this.fDescription = UNKNOWN;
        this.fSourceTypeId = UNKNOWN;
        this.fParameters = new HashMap<String, Object>();
    }

    private TmfConfiguration(Builder builder) {
        this.fId = Objects.requireNonNull(builder.fId);
        this.fName = builder.fName;
        this.fDescription = builder.fDescription;
        this.fSourceTypeId = Objects.requireNonNull(builder.fSourceTypeId);
        this.fParameters = builder.fParameters;
    }

    @Override
    public String getName() {
        String name = this.fName;
        if (name == null) {
            return UNKNOWN;
        }
        return name;
    }

    @Override
    public String getId() {
        String id = this.fId;
        if (id == null || id.isBlank()) {
            this.fId = id = TmfConfiguration.toUuidString(this.getName());
        }
        return id;
    }

    @Override
    public String getSourceTypeId() {
        String sourceTypeId = this.fSourceTypeId;
        if (sourceTypeId == null) {
            return UNKNOWN;
        }
        return sourceTypeId;
    }

    @Override
    public String getDescription() {
        String desc = this.fDescription;
        if (desc == null) {
            return UNKNOWN;
        }
        return desc;
    }

    @Override
    public Map<String, Object> getParameters() {
        Map<String, Object> parameters = this.fParameters;
        if (parameters == null) {
            return new HashMap<String, Object>();
        }
        return parameters;
    }

    private static String toUuidString(String name) {
        return UUID.nameUUIDFromBytes(Objects.requireNonNull(name.getBytes(Charset.defaultCharset()))).toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "fName=" + this.getName() + ", fDescription=" + this.getDescription() + ", fType=" + this.getSourceTypeId() + ", fId=" + this.getId() + ", fParameters=" + this.getParameters() + "]";
    }

    public boolean equals(@Nullable Object arg0) {
        if (!(arg0 instanceof TmfConfiguration)) {
            return false;
        }
        TmfConfiguration other = (TmfConfiguration)arg0;
        return Objects.equals(this.fName, other.fName) && Objects.equals(this.fId, other.fId) && Objects.equals(this.fSourceTypeId, other.fSourceTypeId) && Objects.equals(this.fDescription, other.fDescription) && Objects.equals(this.fParameters, other.fParameters);
    }

    public int hashCode() {
        return Objects.hash(this.fName, this.fId, this.fSourceTypeId, this.fDescription, this.fParameters);
    }

    public static ITmfConfiguration fromJsonFile(File jsonFile) throws TmfConfigurationException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileReader reader = new FileReader(jsonFile);){
                return (ITmfConfiguration)new Gson().fromJson((Reader)reader, TmfConfiguration.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException | IOException e) {
            Activator.logError(e.getMessage(), e);
            throw new TmfConfigurationException("Can't parse JSON file. " + jsonFile.getName(), e);
        }
    }

    public static void writeConfiguration(ITmfConfiguration configuration, IPath rootPath) throws TmfConfigurationException {
        IPath supplPath = rootPath;
        File folder = supplPath.toFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        supplPath = supplPath.addTrailingSeparator().append(configuration.getId()).addFileExtension(JSON_EXTENSION);
        File file = supplPath.toFile();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (FileWriter writer = new FileWriter(file);){
                ((Writer)writer).append(new Gson().toJson((Object)configuration));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException | IOException e) {
            Activator.logError(e.getMessage(), e);
            throw new TmfConfigurationException("Error writing configuration.", e);
        }
    }

    public static class Builder {
        private String fId = "";
        private String fName = "";
        private String fDescription = "";
        private String fSourceTypeId = "";
        private Map<String, Object> fParameters = new HashMap<String, Object>();

        public Builder setId(String id) {
            this.fId = id;
            return this;
        }

        public Builder setName(String name) {
            this.fName = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.fDescription = description;
            return this;
        }

        public Builder setSourceTypeId(String sourceTypeId) {
            this.fSourceTypeId = sourceTypeId;
            return this;
        }

        public Builder setParameters(Map<String, Object> parameters) {
            this.fParameters = parameters;
            return this;
        }

        public ITmfConfiguration build() {
            if (this.fId.isBlank()) {
                this.fId = TmfConfiguration.toUuidString(this.fName.isBlank() ? TmfConfiguration.UNKNOWN : this.fName);
            }
            return new TmfConfiguration(this);
        }
    }
}

