/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.UnaryStringParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class TsdlUtils {
    private static final UnaryStringParser STRING_PARSER = UnaryStringParser.INSTANCE;

    private TsdlUtils() {
    }

    public static boolean isUnaryString(ICTFMetadataNode node) {
        return CTFParser.tokenNames[121].equals(node.getType());
    }

    public static boolean isAnyUnaryString(ICTFMetadataNode node) {
        return TsdlUtils.isUnaryString(node) || CTFParser.tokenNames[122].equals(node.getType());
    }

    public static boolean isUnaryInteger(ICTFMetadataNode node) {
        return CTFParser.tokenNames[118].equals(node.getType()) || CTFParser.tokenNames[119].equals(node.getType()) || CTFParser.tokenNames[120].equals(node.getType());
    }

    public static @NonNull String concatenateUnaryStrings(List<ICTFMetadataNode> strings) throws ParseException {
        StringBuilder sb = new StringBuilder();
        ICTFMetadataNode first = strings.get(0);
        sb.append(STRING_PARSER.parse(first, null));
        boolean isFirst = true;
        for (ICTFMetadataNode ref : strings) {
            if (isFirst) {
                isFirst = false;
                continue;
            }
            ICTFMetadataNode id = ref.getChild(0);
            if (CTFParser.tokenNames[5].equals(ref.getType())) {
                sb.append("->");
            } else {
                sb.append('.');
            }
            sb.append(STRING_PARSER.parse(id, null));
        }
        return sb.toString();
    }

    public static ParseException childTypeError(ICTFMetadataNode child) {
        ICTFMetadataNode parent = child.getParent();
        String error = "Parent " + parent.getType() + " can't have a child of type " + child.getType() + ".";
        return new ParseException(error);
    }
}

