/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.event.aspect;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.Messages;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelTidAspect;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataType;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public final class ThreadPriorityAspect
implements ITmfEventAspect<Integer> {
    public static final ThreadPriorityAspect INSTANCE = new ThreadPriorityAspect();

    private ThreadPriorityAspect() {
    }

    public final String getName() {
        return NonNullUtils.nullToEmptyString((Object)Messages.AspectName_Prio);
    }

    public final String getHelpText() {
        return NonNullUtils.nullToEmptyString((Object)Messages.AspectHelpText_Prio);
    }

    public @Nullable Integer resolve(ITmfEvent event) {
        @NonNull ITmfTrace trace = event.getTrace();
        KernelAnalysisModule kernelAnalysis = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (kernelAnalysis == null) {
            return null;
        }
        ITmfStateSystem ss = kernelAnalysis.getStateSystem();
        if (ss == null) {
            return null;
        }
        Integer tid = KernelTidAspect.INSTANCE.resolve(event);
        if (tid == null) {
            return null;
        }
        long ts = event.getTimestamp().getValue();
        Integer execPrio = null;
        try {
            Integer cpu = 0;
            if (tid == 0) {
                cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)trace, TmfCpuAspect.class, (ITmfEvent)event);
            }
            int execPrioQuark = ss.getQuarkAbsolute(new String[]{"Threads", Attributes.buildThreadAttributeName(tid, cpu), "Prio"});
            ITmfStateInterval interval = ss.querySingleState(ts, execPrioQuark);
            ITmfStateValue prioValue = interval.getStateValue();
            execPrio = prioValue.unboxInt();
        }
        catch (AttributeNotFoundException | StateSystemDisposedException | TimeRangeException throwable) {
            // empty catch block
        }
        return execPrio;
    }

    public DataType getDataType() {
        return DataType.NUMBER;
    }
}

