/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.parser.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.cdt.core.parser.util.HashTable;
import org.eclipse.cdt.core.parser.util.IObjectMatcher;

public abstract class ObjectTable<T>
extends HashTable
implements Iterable<T> {
    protected T[] keyTable = new Object[this.capacity()];

    public ObjectTable(int initialSize) {
        super(initialSize);
    }

    @Override
    public Object clone() {
        ObjectTable newTable = (ObjectTable)super.clone();
        int size = this.capacity();
        newTable.keyTable = new Object[size];
        System.arraycopy(this.keyTable, 0, newTable.keyTable, 0, this.keyTable.length);
        return newTable;
    }

    public List<T> toList() {
        int size = this.size();
        ArrayList<T> list = new ArrayList<T>(size);
        int i = 0;
        while (i < size) {
            list.add(this.keyAt(i));
            ++i;
        }
        return list;
    }

    public T keyAt(int i) {
        if (i < 0 || i > this.currEntry) {
            return null;
        }
        return this.keyTable[i];
    }

    @Override
    public void clear() {
        super.clear();
        Arrays.fill(this.keyTable, null);
    }

    @Override
    protected final int hash(int pos) {
        return this.hash(this.keyTable[pos]);
    }

    private int hash(Object obj) {
        return this.hashTable == null ? 0 : this.hashToOffset(obj.hashCode());
    }

    @Override
    protected void resize(int size) {
        T[] oldKeyTable = this.keyTable;
        this.keyTable = new Object[size];
        System.arraycopy(oldKeyTable, 0, this.keyTable, 0, oldKeyTable.length);
        super.resize(size);
    }

    protected final int add(T obj) {
        int pos = this.lookup(obj);
        if (pos != -1) {
            return pos;
        }
        if (this.currEntry + 1 >= this.capacity()) {
            this.resize();
        }
        ++this.currEntry;
        this.keyTable[this.currEntry] = obj;
        this.linkIntoHashTable(this.currEntry, this.hash(obj));
        return this.currEntry;
    }

    protected void removeEntry(int i) {
        int hash = this.hash(this.keyTable[i]);
        if (i < this.currEntry) {
            System.arraycopy(this.keyTable, i + 1, this.keyTable, i, this.currEntry - i);
        }
        this.keyTable[this.currEntry] = null;
        this.removeEntry(i, hash);
    }

    protected final int lookup(Object buffer) {
        if (this.hashTable != null) {
            int hash = this.hash(buffer);
            if (this.hashTable[hash] == 0) {
                return -1;
            }
            int i = this.hashTable[hash] - 1;
            if (buffer.equals(this.keyTable[i])) {
                return i;
            }
            i = this.nextTable[i] - 1;
            while (i >= 0 && i != this.nextTable[i] - 1) {
                if (buffer.equals(this.keyTable[i])) {
                    return i;
                }
                i = this.nextTable[i] - 1;
            }
            return -1;
        }
        int i = 0;
        while (i <= this.currEntry) {
            if (buffer.equals(this.keyTable[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean containsKey(T key) {
        return this.lookup(key) != -1;
    }

    public Object[] keyArray() {
        Object[] keys = new Object[this.size()];
        System.arraycopy(this.keyTable, 0, keys, 0, keys.length);
        return keys;
    }

    public <X> X[] keyArray(Class<X> c) {
        Object[] keys = (Object[])Array.newInstance(c, this.size());
        System.arraycopy(this.keyTable, 0, keys, 0, keys.length);
        return keys;
    }

    public boolean isEquivalent(ObjectTable<T> other, IObjectMatcher matcher) {
        if (this.size() != other.size()) {
            return false;
        }
        int i = 0;
        while (i < this.keyTable.length) {
            T key1 = this.keyTable[i];
            T key2 = other.keyTable[i];
            if (key1 != key2 && !matcher.isEquivalent(key1, key2)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int nextIndex;

            @Override
            public boolean hasNext() {
                return this.nextIndex < ObjectTable.this.size();
            }

            @Override
            public T next() {
                Object element = ObjectTable.this.keyAt(this.nextIndex);
                if (element == null) {
                    throw new NoSuchElementException();
                }
                ++this.nextIndex;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return Arrays.toString(this.keyTable);
    }
}

