/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplate;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPAliasTemplateInstance;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateArgument;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.Linkage;
import org.eclipse.cdt.internal.core.dom.parser.ITypeContainer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPSpecialization;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;

public class CPPAliasTemplateInstance
extends CPPSpecialization
implements ICPPAliasTemplateInstance,
ITypeContainer {
    private IType aliasedType;
    private ICPPTemplateArgument[] fArguments;

    public CPPAliasTemplateInstance(ICPPAliasTemplate aliasTemplate, IType aliasedType, IBinding owner, ICPPTemplateParameterMap argumentMap, ICPPTemplateArgument[] arguments) {
        super(aliasTemplate, owner, argumentMap);
        this.aliasedType = aliasedType;
        this.fArguments = arguments;
    }

    @Override
    public ICPPAliasTemplate getTemplateDefinition() {
        return (ICPPAliasTemplate)super.getSpecializedBinding();
    }

    @Override
    public boolean isSameType(IType other) {
        if (other == this.aliasedType) {
            return true;
        }
        if (this.aliasedType != null) {
            return this.aliasedType.isSameType(other);
        }
        return false;
    }

    @Override
    public IType getType() {
        return this.aliasedType;
    }

    @Override
    public void setType(IType type) {
        this.aliasedType = type;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public String getName() {
        return new String(this.getNameCharArray());
    }

    @Override
    public char[] getNameCharArray() {
        char[] name = this.getTemplateDefinition().getNameCharArray();
        if (name != null) {
            return name;
        }
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    public ILinkage getLinkage() {
        return Linkage.CPP_LINKAGE;
    }

    @Override
    public IBinding getOwner() {
        if (this.getTemplateDefinition() != null) {
            return this.getTemplateDefinition().getOwner();
        }
        return null;
    }

    @Override
    public IScope getScope() throws DOMException {
        if (this.getTemplateDefinition() != null) {
            return this.getTemplateDefinition().getScope();
        }
        return null;
    }

    @Override
    public String[] getQualifiedName() {
        return CPPVisitor.getQualifiedName(this);
    }

    @Override
    public char[][] getQualifiedNameCharArray() {
        return CPPVisitor.getQualifiedNameCharArray(this);
    }

    @Override
    public boolean isGloballyQualified() throws DOMException {
        return this.getTemplateDefinition().isGloballyQualified();
    }

    @Override
    public IASTNode getDefinition() {
        if (this.getTemplateDefinition() instanceof ICPPInternalBinding) {
            return ((ICPPInternalBinding)((Object)this.getTemplateDefinition())).getDefinition();
        }
        return null;
    }

    @Override
    public IASTNode[] getDeclarations() {
        return null;
    }

    @Override
    public void addDefinition(IASTNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeclaration(IASTNode node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return ASTTypeUtil.getQualifiedName(this) + " -> " + ASTTypeUtil.getType(this.aliasedType, true);
    }

    @Override
    public ICPPTemplateArgument[] getTemplateArguments() {
        return this.fArguments;
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }
}

