/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.io.IOException;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.ResponseProcessingException;
import javax.ws.rs.core.Response;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.jersey.client.AbortException;
import org.glassfish.jersey.client.ClientRequest;
import org.glassfish.jersey.client.ClientResponse;
import org.glassfish.jersey.client.InboundJaxrsResponse;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.model.internal.RankedComparator;
import org.glassfish.jersey.process.internal.AbstractChainableStage;
import org.glassfish.jersey.process.internal.ChainableStage;
import org.glassfish.jersey.process.internal.Stage;

class ClientFilteringStages {
    private ClientFilteringStages() {
    }

    static ChainableStage<ClientRequest> createRequestFilteringStage(ServiceLocator locator) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.ASCENDING);
        Iterable requestFilters = Providers.getAllProviders((ServiceLocator)locator, ClientRequestFilter.class, (RankedComparator)comparator);
        return requestFilters.iterator().hasNext() ? new RequestFilteringStage(requestFilters) : null;
    }

    static ChainableStage<ClientResponse> createResponseFilteringStage(ServiceLocator locator) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.DESCENDING);
        Iterable responseFilters = Providers.getAllProviders((ServiceLocator)locator, ClientResponseFilter.class, (RankedComparator)comparator);
        return responseFilters.iterator().hasNext() ? new ResponseFilterStage(responseFilters) : null;
    }

    private static final class RequestFilteringStage
    extends AbstractChainableStage<ClientRequest> {
        private final Iterable<ClientRequestFilter> requestFilters;

        private RequestFilteringStage(Iterable<ClientRequestFilter> requestFilters) {
            this.requestFilters = requestFilters;
        }

        public Stage.Continuation<ClientRequest> apply(ClientRequest requestContext) {
            for (ClientRequestFilter filter : this.requestFilters) {
                try {
                    filter.filter((ClientRequestContext)requestContext);
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    throw new AbortException(new ClientResponse(requestContext, abortResponse));
                }
                catch (IOException ex) {
                    throw new ProcessingException((Throwable)ex);
                }
            }
            return Stage.Continuation.of((Object)((Object)requestContext), (Stage)this.getDefaultNext());
        }
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ClientResponse> {
        private final Iterable<ClientResponseFilter> filters;

        private ResponseFilterStage(Iterable<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        public Stage.Continuation<ClientResponse> apply(ClientResponse responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter((ClientRequestContext)responseContext.getRequestContext(), (ClientResponseContext)responseContext);
                }
            }
            catch (IOException ex) {
                InboundJaxrsResponse response = new InboundJaxrsResponse(responseContext, null);
                throw new ResponseProcessingException((Response)response, (Throwable)ex);
            }
            return Stage.Continuation.of((Object)((Object)responseContext), (Stage)this.getDefaultNext());
        }
    }
}

