/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.rocm.core.trace;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.rocm.core.Activator;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old.RocmMetadataAnalysis;
import org.eclipse.tracecompass.incubator.rocm.core.trace.old.RocmTrace;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.TmfResolvedSymbol;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class RocmTraceSymbolProvider
implements ISymbolProvider {
    private @NonNull ITmfTrace fTrace;

    public RocmTraceSymbolProvider(@NonNull ITmfTrace trace) {
        this.fTrace = trace;
    }

    public @NonNull ITmfTrace getTrace() {
        return this.fTrace;
    }

    public void loadConfiguration(@Nullable IProgressMonitor monitor) {
    }

    public @Nullable TmfResolvedSymbol getSymbol(long address) {
        String functionName;
        RocmMetadataAnalysis module = (RocmMetadataAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)this.getTrace(), RocmMetadataAnalysis.class, (String)"org.eclipse.tracecompass.incubator.rocm.core.analysis.functionname");
        if (module == null) {
            return null;
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null || address == -1L) {
            return new TmfResolvedSymbol(address, "");
        }
        try {
            RocmTrace trace = (RocmTrace)this.getTrace();
            int nApi = trace.getNApi();
            Integer apiId = (int)(address % (long)nApi);
            int cid = (int)((address - (long)apiId.intValue()) / (long)nApi);
            int functionNameQuark = ss.getQuarkAbsolute(new String[]{"Function Names"});
            int apiQuark = ss.getQuarkRelative(functionNameQuark, new String[]{apiId.toString()});
            functionName = ss.querySingleState(ss.getStartTime() + (long)cid, apiQuark).getValueString();
            if (functionName == null) {
                functionName = "";
                Activator.getInstance().logWarning("The function name with cid " + cid + " and the apiId " + String.valueOf(apiId) + " was not found in the state system");
            }
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Activator.getInstance().logError(e.getMessage());
            return new TmfResolvedSymbol(address, "");
        }
        return new TmfResolvedSymbol(address, functionName);
    }

    public @Nullable TmfResolvedSymbol getSymbol(int pid, long timestamp, long address) {
        return this.getSymbol(address);
    }
}

