/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.old;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.internal.rocm.core.Activator;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.dependency.HipApiHipActivityDependencyMaker;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.AbstractGpuEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.ApiEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.HipActivityEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.HsaActivityEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.HsaKernelEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.old.RoctxEventHandler;
import org.eclipse.tracecompass.incubator.rocm.core.analysis.dependency.IDependencyMaker;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTraceWithPreDefinedEvents;

public class RocmCallStackStateProvider
extends AbstractTmfStateProvider {
    private static final String ID = "org.eclipse.tracecompass.incubator.rocm.core.stateprovider.interval";
    private IDependencyMaker fDependencyMaker;
    private Map<String, AbstractGpuEventHandler> fEventNames;

    public RocmCallStackStateProvider(@NonNull ITmfTrace trace) {
        super(trace, ID);
        this.fDependencyMaker = RocmCallStackStateProvider.getDependencyMaker((ITmfTraceWithPreDefinedEvents)trace);
        this.fEventNames = this.buildEventNames();
    }

    private Map<String, AbstractGpuEventHandler> buildEventNames() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"hip_api", (Object)new ApiEventHandler(this));
        builder.put((Object)"hsa_api", (Object)new ApiEventHandler(this));
        builder.put((Object)"hip_activity", (Object)new HipActivityEventHandler(this));
        builder.put((Object)"roctx", (Object)new RoctxEventHandler(this));
        builder.put((Object)"hsa_activity", (Object)new HsaActivityEventHandler(this));
        if (this.fDependencyMaker == null) {
            builder.put((Object)"kernel_event", (Object)new HsaKernelEventHandler(this));
        }
        return builder.build();
    }

    private static IDependencyMaker getDependencyMaker(ITmfTraceWithPreDefinedEvents trace) {
        HipApiHipActivityDependencyMaker dependencyMaker = null;
        for (ITmfEventType eventType : trace.getContainedEventTypes()) {
            if (!eventType.getName().equals("hip_activity")) continue;
            dependencyMaker = new HipApiHipActivityDependencyMaker();
            break;
        }
        return dependencyMaker;
    }

    public int getVersion() {
        return 1;
    }

    public @NonNull ITmfStateProvider getNewInstance() {
        return new RocmCallStackStateProvider(this.getTrace());
    }

    protected void eventHandle(@NonNull ITmfEvent event) {
        String eventName = event.getName();
        ITmfStateSystemBuilder ssb = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
        try {
            AbstractGpuEventHandler handler = this.fEventNames.get(eventName);
            if (handler != null) {
                handler.handleEvent(ssb, event);
            }
        }
        catch (AttributeNotFoundException e) {
            Activator.getInstance().logError("Exception while building the RocmCallStack state system", (Throwable)e);
        }
        if (this.fDependencyMaker != null) {
            this.fDependencyMaker.processEvent(event, ssb);
        }
    }

    public IDependencyMaker getDependencyMaker() {
        return this.fDependencyMaker;
    }
}

