/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.dependency;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.incubator.callstack.core.base.EdgeStateValue;
import org.eclipse.tracecompass.incubator.rocm.core.analysis.dependency.IDependencyMaker;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;

public abstract class AbstractDependencyMaker
implements IDependencyMaker {
    protected AbstractDependencyMaker() {
    }

    public static void addArrow(ITmfStateSystemBuilder ssb, Long startTime, Long endTime, int id, @NonNull HostThread src, @NonNull HostThread dest) {
        int edgeQuark = AbstractDependencyMaker.getAvailableEdgeQuark(ssb, startTime);
        EdgeStateValue edgeStateValue = new EdgeStateValue(id, src, dest);
        ssb.modifyAttribute(startTime.longValue(), (Object)edgeStateValue, edgeQuark);
        ssb.modifyAttribute(endTime.longValue(), null, edgeQuark);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static int getAvailableEdgeQuark(ITmfStateSystemBuilder ssb, long startTime) {
        int edgeRoot = ssb.getQuarkAbsoluteAndAdd(new String[]{"Edges"});
        @NonNull List subQuarks = ssb.getSubAttributes(edgeRoot, false);
        Iterator iterator = subQuarks.iterator();
        while (iterator.hasNext()) {
            int quark = (Integer)iterator.next();
            long start = ssb.getOngoingStartTime(quark);
            Object value = ssb.queryOngoing(quark);
            if (value != null || start > startTime) continue;
            return quark;
        }
        return ssb.getQuarkRelativeAndAdd(edgeRoot, new String[]{Integer.toString(subQuarks.size())});
    }
}

