/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.trace;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.counters.core.CounterType;
import org.eclipse.tracecompass.incubator.internal.otf2.core.Activator;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class MetricMember {
    private final long fMetricMemberId;
    private final String fName;
    private final String fDescription;
    private final int fMetricType;
    private final int fMetricMode;
    private final int fValueTypeCode;
    private CounterType fCounterType = CounterType.LONG;
    private final int fBase;
    private final long fExponent;
    private double fFactor;
    private final String fUnit;

    public MetricMember(ITmfEvent event, Map<Integer, String> stringIds) {
        ITmfEventField content = event.getContent();
        Long selfId = (Long)content.getFieldValue(Long.class, new String[]{"self"});
        this.fMetricMemberId = selfId != null ? selfId : 0xFFFFFFFFL;
        Long nameId = (Long)content.getFieldValue(Long.class, new String[]{"name"});
        nameId = nameId != null ? nameId : 0xFFFFFFFFL;
        String name = stringIds.get(nameId.intValue());
        this.fName = name = name != null ? name : "UNKNOWN";
        Long descriptionId = (Long)content.getFieldValue(Long.class, new String[]{"description"});
        descriptionId = descriptionId != null ? descriptionId : 0xFFFFFFFFL;
        String description = stringIds.get(descriptionId.intValue());
        this.fDescription = description = description != null ? description : "UNKNOWN";
        Integer metricType = (Integer)content.getFieldValue(Integer.class, new String[]{"metricType"});
        this.fMetricType = metricType != null ? metricType : 255;
        Integer metricMode = (Integer)content.getFieldValue(Integer.class, new String[]{"metricMode"});
        this.fMetricMode = metricMode != null ? metricMode : 255;
        Integer valueType = (Integer)content.getFieldValue(Integer.class, new String[]{"valueType"});
        this.fValueTypeCode = valueType != null ? valueType : 255;
        Integer base = (Integer)content.getFieldValue(Integer.class, new String[]{"base"});
        this.fBase = base != null ? base : 255;
        Long exponent = (Long)content.getFieldValue(Long.class, new String[]{"exponent"});
        this.fExponent = exponent != null ? exponent : Long.MIN_VALUE;
        this.setCounterType();
        this.computeAndSetFactor();
        Long unitId = (Long)content.getFieldValue(Long.class, new String[]{"unit"});
        unitId = unitId != null ? unitId : 0xFFFFFFFFL;
        String unit = stringIds.get(unitId.intValue());
        this.fUnit = unit = unit != null ? unit : "UNKNOWN";
    }

    public long getId() {
        return this.fMetricMemberId;
    }

    public String getName() {
        return this.fName;
    }

    private void computeAndSetFactor() {
        this.fFactor = Math.pow(switch (this.fBase) {
            case 0 -> 2.0;
            case 1 -> 10.0;
            default -> 0.0;
        }, this.fExponent);
    }

    public Number computeValueWithDefinedUnit(Number rawValue) {
        switch (this.fCounterType) {
            case DOUBLE: {
                return rawValue.doubleValue() * this.fFactor;
            }
            case LONG: {
                return rawValue.longValue() * (long)this.fFactor;
            }
        }
        return 0;
    }

    private void setCounterType() {
        if (this.fExponent < 0L) {
            this.fCounterType = CounterType.DOUBLE;
            return;
        }
        switch (this.fValueTypeCode) {
            case 4: 
            case 8: {
                this.fCounterType = CounterType.LONG;
                break;
            }
            case 10: {
                this.fCounterType = CounterType.DOUBLE;
                break;
            }
            default: {
                Activator.getInstance().logWarning("The counter type for this OTF2 trace is not supported.");
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetricMember)) {
            return false;
        }
        MetricMember otherMetricMember = (MetricMember)other;
        return this.fName.equals(otherMetricMember.fName) && this.fMetricMode == otherMetricMember.fMetricMode && this.fMetricType == otherMetricMember.fMetricType && this.fFactor == otherMetricMember.fFactor && this.fUnit.equals(otherMetricMember.fUnit);
    }

    public int hashCode() {
        return Objects.hash(this.fName.hashCode(), this.fMetricMode, this.fMetricType, this.fFactor, this.fUnit.hashCode());
    }

    public int getValueType() {
        return this.fValueTypeCode;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getUnit() {
        return this.fUnit;
    }

    public int getMode() {
        return this.fMetricMode;
    }

    public CounterType getCounterType() {
        return this.fCounterType;
    }
}

