/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.communicators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.communicators.Otf2CommunicatorsAnalysis;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.AbstractTimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2CommunicatorsDataProvider
extends AbstractTimeGraphDataProvider<Otf2CommunicatorsAnalysis, TimeGraphEntryModel>
implements IOutputStyleProvider {
    private static final int NUM_COLORS = 360;
    private static final IPaletteProvider PALETTE = new RotatingPaletteProvider.Builder().setNbColors(360).build();
    private static final Map<String, OutputElementStyle> STYLE_MAP;
    public static final String SUFFIX = ".dataprovider";

    static {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        int i = 0;
        for (RGBAColor color : PALETTE.get()) {
            builder.put((Object)String.valueOf(i), (Object)new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"style-name", (Object)String.valueOf(i), (Object)"background-color", (Object)color.toString().substring(0, 7))));
            ++i;
        }
        STYLE_MAP = builder.build();
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse((Object)new OutputStyleModel(STYLE_MAP), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public Otf2CommunicatorsDataProvider(ITmfTrace trace, Otf2CommunicatorsAnalysis analysisModule) {
        super(trace, (TmfStateSystemAnalysisModule)analysisModule);
    }

    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    public String getId() {
        return String.valueOf(((Otf2CommunicatorsAnalysis)this.getAnalysisModule()).getId()) + SUFFIX;
    }

    protected @Nullable TimeGraphModel getRowModel(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TreeMultimap intervals = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(ITmfStateInterval::getStartTime));
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(parameters);
        if (filter == null) {
            return null;
        }
        Map entries = this.getSelectedEntries(filter);
        Collection times = Otf2CommunicatorsDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)ss.getCurrentEndTime());
        for (ITmfStateInterval interval : ss.query2D(entries.values(), times)) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            intervals.put((Object)interval.getAttribute(), (Object)interval);
        }
        HashMap predicates = new HashMap();
        Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(parameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        ArrayList<TimeGraphRowModel> rows = new ArrayList<TimeGraphRowModel>();
        for (Map.Entry entry : entries.entrySet()) {
            if (monitor != null && monitor.isCanceled()) {
                return new TimeGraphModel(Collections.emptyList());
            }
            ArrayList eventList = new ArrayList();
            for (ITmfStateInterval interval : intervals.get((Object)((Integer)entry.getValue()))) {
                TimeGraphState value;
                long startTime = interval.getStartTime();
                long duration = interval.getEndTime() - startTime + 1L;
                Object valObject = interval.getValue();
                if (valObject == null) {
                    TimeGraphState value2 = new TimeGraphState(startTime, duration, null, null);
                    this.applyFilterAndAddState(eventList, (ITimeGraphState)value2, (Long)entry.getKey(), predicates, monitor);
                }
                if (valObject instanceof String) {
                    String name = (String)valObject;
                    int indexColor = Math.floorMod(name.hashCode(), PALETTE.get().size()) + 1;
                    value = new TimeGraphState(startTime, duration, name, STYLE_MAP.get(String.valueOf(indexColor)));
                    this.applyFilterAndAddState(eventList, (ITimeGraphState)value, (Long)entry.getKey(), predicates, monitor);
                }
                if (!(valObject instanceof Long)) continue;
                Integer numberOfNodes = ss.getSubAttributes(((Integer)entry.getValue()).intValue(), false).size();
                Long numberOfPendingThreads = (Long)valObject;
                if (numberOfPendingThreads > 0L) {
                    OutputElementStyle style = new OutputElementStyle(null, (Map)ImmutableMap.of((Object)"background-color", (Object)"#FF0000", (Object)"opacity", (Object)Float.valueOf(Math.min(1.0f, 0.1f + (float)numberOfPendingThreads.longValue() / (float)numberOfNodes.intValue() * 0.5f))));
                    TimeGraphState value3 = new TimeGraphState(startTime, duration, numberOfPendingThreads.toString(), style);
                    this.applyFilterAndAddState(eventList, (ITimeGraphState)value3, (Long)entry.getKey(), predicates, monitor);
                    continue;
                }
                value = new TimeGraphState(startTime, duration, null, null);
                this.applyFilterAndAddState(eventList, (ITimeGraphState)value, (Long)entry.getKey(), predicates, monitor);
            }
            rows.add(new TimeGraphRowModel(((Long)entry.getKey()).longValue(), eventList));
        }
        return new TimeGraphModel(rows);
    }

    protected boolean isCacheable() {
        return false;
    }

    protected TmfTreeModel<TimeGraphEntryModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        long parentId = this.getId(-1);
        builder.add((Object)new TimeGraphEntryModel(parentId, -1L, String.valueOf(this.getTrace().getName()), ss.getStartTime(), ss.getCurrentEndTime()));
        this.addChildren(ss, (ImmutableList.Builder<TimeGraphEntryModel>)builder, -1, parentId);
        return new TmfTreeModel(Collections.emptyList(), (List)builder.build());
    }

    private void addChildren(ITmfStateSystem ss, ImmutableList.Builder<TimeGraphEntryModel> builder, int quark, long parentId) {
        for (Integer child : ss.getSubAttributes(quark, false)) {
            long childId = this.getId(child);
            String name = ss.getAttributeName(child.intValue());
            builder.add((Object)new TimeGraphEntryModel(childId, parentId, name, ss.getStartTime(), ss.getCurrentEndTime(), true));
            this.addChildren(ss, builder, child, childId);
        }
    }

    public static String getFullDataProviderId() {
        return String.valueOf(Otf2CommunicatorsAnalysis.getFullAnalysisId()) + SUFFIX;
    }
}

