/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.Node;

final class CheckSuspiciousCode
extends NodeTraversal.AbstractPostOrderCallback {
    static final DiagnosticType SUSPICIOUS_SEMICOLON = DiagnosticType.warning("JSC_SUSPICIOUS_SEMICOLON", "If this if/for/while really shouldn''t have a body, use '{}'");
    static final DiagnosticType SUSPICIOUS_COMPARISON_WITH_NAN = DiagnosticType.warning("JSC_SUSPICIOUS_NAN", "Comparison against NaN is always false. Did you mean isNaN()?");
    static final DiagnosticType SUSPICIOUS_IN_OPERATOR = DiagnosticType.warning("JSC_SUSPICIOUS_IN", "Use of the \"in\" keyword on non-object types throws an exception.");
    static final DiagnosticType SUSPICIOUS_INSTANCEOF_LEFT_OPERAND = DiagnosticType.warning("JSC_SUSPICIOUS_INSTANCEOF_LEFT", "\"instanceof\" with left non-object operand is always false.");
    static final DiagnosticType SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR = DiagnosticType.warning("JSC_SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR", "Suspicious negated left operand of 'in' operator.");

    CheckSuspiciousCode() {
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        this.checkMissingSemicolon(t, n);
        this.checkNaN(t, n);
        this.checkInvalidIn(t, n);
        this.checkNonObjectInstanceOf(t, n);
        this.checkNegatedLeftOperandOfInOperator(t, n);
    }

    private void checkMissingSemicolon(NodeTraversal t, Node n) {
        switch (n.getType()) {
            case 108: {
                Node trueCase = n.getSecondChild();
                CheckSuspiciousCode.reportIfWasEmpty(t, trueCase);
                Node elseCase = trueCase.getNext();
                if (elseCase == null) break;
                CheckSuspiciousCode.reportIfWasEmpty(t, elseCase);
                break;
            }
            case 113: 
            case 115: 
            case 163: {
                CheckSuspiciousCode.reportIfWasEmpty(t, NodeUtil.getLoopCodeBlock(n));
            }
        }
    }

    private static void reportIfWasEmpty(NodeTraversal t, Node block) {
        Preconditions.checkState((boolean)block.isBlock());
        if (!block.hasChildren() && block.isAddedBlock()) {
            t.getCompiler().report(t.makeError(block, SUSPICIOUS_SEMICOLON, new String[0]));
        }
    }

    private void checkNaN(NodeTraversal t, Node n) {
        switch (n.getType()) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 45: 
            case 46: {
                CheckSuspiciousCode.reportIfNaN(t, n.getFirstChild());
                CheckSuspiciousCode.reportIfNaN(t, n.getLastChild());
            }
        }
    }

    private static void reportIfNaN(NodeTraversal t, Node n) {
        if (NodeUtil.isNaN(n)) {
            t.getCompiler().report(t.makeError(n.getParent(), SUSPICIOUS_COMPARISON_WITH_NAN, new String[0]));
        }
    }

    private void checkInvalidIn(NodeTraversal t, Node n) {
        if (n.getType() == 51) {
            CheckSuspiciousCode.reportIfNonObject(t, n.getLastChild(), SUSPICIOUS_IN_OPERATOR);
        }
    }

    private void checkNonObjectInstanceOf(NodeTraversal t, Node n) {
        if (n.getType() == 52) {
            CheckSuspiciousCode.reportIfNonObject(t, n.getFirstChild(), SUSPICIOUS_INSTANCEOF_LEFT_OPERAND);
        }
    }

    private static boolean reportIfNonObject(NodeTraversal t, Node n, DiagnosticType diagnosticType) {
        if (n.isAdd() || !NodeUtil.mayBeObect(n)) {
            t.report(n.getParent(), diagnosticType, new String[0]);
            return true;
        }
        return false;
    }

    private void checkNegatedLeftOperandOfInOperator(NodeTraversal t, Node n) {
        if (n.isIn() && n.getFirstChild().isNot()) {
            t.report(n.getFirstChild(), SUSPICIOUS_NEGATED_LEFT_OPERAND_OF_IN_OPERATOR, new String[0]);
        }
    }
}

