/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.communicators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.AbstractOtf2StateProvider;
import org.eclipse.tracecompass.incubator.internal.otf2.core.analysis.communicators.Otf2CommunicatorsAnalysis;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.CollectiveOperationIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.mpi.MessageIdentifiers;
import org.eclipse.tracecompass.incubator.internal.otf2.core.trace.Location;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class Otf2CommunicatorsStateProvider
extends AbstractOtf2StateProvider {
    private static final String COMMUNICATOR = "Communicator ";
    private static final String RANK = "Rank ";
    private static int VERSION_NUMBER = 1;
    private final Map<Long, CommunicatorsLocation> fMapLocation = new HashMap<Long, CommunicatorsLocation>();
    private final Map<Integer, Communicator> fMapCommunicator = new HashMap<Integer, Communicator>();
    private final long fLastTimestamp;

    public Otf2CommunicatorsStateProvider(ITmfTrace trace) {
        super(trace, Otf2CommunicatorsAnalysis.getFullAnalysisId());
        this.fLastTimestamp = trace.readEnd().toNanos();
    }

    public int getVersion() {
        return VERSION_NUMBER;
    }

    @Override
    protected void eventHandle(ITmfEvent event) {
        super.eventHandle(event);
        if (this.isLastEvent(event)) {
            ITmfStateSystemBuilder ssb = this.getStateSystemBuilder();
            if (ssb == null) {
                return;
            }
            this.processLocationsAttributes(ssb);
            this.processCommunicatorsAttributes(ssb);
        }
    }

    @Override
    protected void processGlobalDefinition(ITmfEvent event, String name) {
        switch (name) {
            case "String": {
                this.processStringDefinition(event);
                break;
            }
            case "Region": {
                this.processRegionDefinition(event);
                break;
            }
            case "Location": {
                CommunicatorsLocation location = new CommunicatorsLocation(event);
                this.fMapLocation.put(location.getId(), location);
                break;
            }
            case "Comm": {
                this.processCommunicatorDefinition(event);
                ITmfEventField content = event.getContent();
                Integer communicatorReference = (Integer)content.getFieldValue(Integer.class, new String[]{"self"});
                if (communicatorReference == null) {
                    return;
                }
                this.fMapCommunicator.put(communicatorReference, new Communicator(communicatorReference));
                break;
            }
            case "Group": {
                this.processGroupDefinition(event);
                break;
            }
            case "GroupMember": {
                this.processGroupMemberDefinition(event);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Override
    protected void processOtf2Event(ITmfEvent event, String name, ITmfStateSystemBuilder ssb) {
        Long locationId = Otf2CommunicatorsStateProvider.getLocationId(event);
        CommunicatorsLocation location = this.fMapLocation.get(locationId);
        if (location == null) {
            return;
        }
        switch (name) {
            case "Enter": {
                location.enter(event);
                break;
            }
            case "Leave": {
                if (!location.fInCommunication && !location.fInIRecvRequest) break;
                location.leave(event, ssb);
                break;
            }
            case "MpiIrecvRequest": {
                location.mpiIRecvRequest(event);
                break;
            }
            case "MpiRecv": 
            case "MpiSend": 
            case "MpiCollectiveEnd": 
            case "MpiIrecv": 
            case "MpiIsend": {
                ITmfEventField content = event.getContent();
                Integer communicatorId = (Integer)content.getFieldValue(Integer.class, new String[]{"communicator"});
                Communicator communicator = this.fMapCommunicator.get(communicatorId);
                if (communicator == null) {
                    return;
                }
                location.fInCommunication = true;
                Otf2CommunicatorsStateProvider.processMpiCommunication(event, ssb, name, location, communicator);
                break;
            }
        }
    }

    private boolean isLastEvent(ITmfEvent event) {
        return this.fLastTimestamp == event.getTimestamp().toNanos();
    }

    private void processCommunicatorsAttributes(ITmfStateSystemBuilder ssb) {
        for (Map.Entry<Integer, Communicator> communicatorEntry : this.fMapCommunicator.entrySet()) {
            Communicator communicator = communicatorEntry.getValue();
            communicator.updatePendingLocations(ssb);
        }
    }

    private void processLocationsAttributes(ITmfStateSystemBuilder ssb) {
        for (Map.Entry<Long, CommunicatorsLocation> locationEntry : this.fMapLocation.entrySet()) {
            CommunicatorsLocation location = locationEntry.getValue();
            location.flushAllUpdates(ssb);
        }
    }

    private static void processMpiCommunication(ITmfEvent event, ITmfStateSystemBuilder ssb, String name, CommunicatorsLocation location, Communicator communicator) {
        if (!communicator.isInitialized()) {
            communicator.initialize(ssb);
        }
        switch (name) {
            case "MpiSend": 
            case "MpiIsend": {
                location.mpiSend(event, communicator);
                break;
            }
            case "MpiRecv": {
                location.mpiRecv(event, communicator, true);
                break;
            }
            case "MpiIrecv": {
                location.mpiRecv(event, communicator, false);
                break;
            }
            case "MpiCollectiveEnd": {
                location.mpiCollective(event, communicator);
                break;
            }
        }
    }

    static /* synthetic */ ITmfStateSystemBuilder access$0(Otf2CommunicatorsStateProvider otf2CommunicatorsStateProvider) {
        return otf2CommunicatorsStateProvider.getStateSystemBuilder();
    }

    private class Communicator {
        protected final int fId;
        protected boolean fQuarkInitialized;
        protected int fQuark;
        protected List<Long> fLocations;
        protected final List<CollectiveOperationIdentifiers> fCollectiveOperations;
        protected final SortedMap<Long, Long> fTimestampsPendingThreads;

        private void incrementPendingThreads(long timestamp, long value) {
            this.fTimestampsPendingThreads.merge(timestamp, value, (oldValue, newValue) -> oldValue + newValue);
        }

        public Communicator(int id) {
            this.fId = id;
            this.fQuarkInitialized = false;
            this.fLocations = new ArrayList<Long>();
            this.fCollectiveOperations = new ArrayList<CollectiveOperationIdentifiers>();
            this.fQuark = -1;
            this.fTimestampsPendingThreads = new TreeMap<Long, Long>();
        }

        public boolean isInitialized() {
            return this.fQuarkInitialized;
        }

        public void initialize(ITmfStateSystemBuilder ssb) {
            ArrayList locations = Otf2CommunicatorsStateProvider.this.getMembersFromCommunicatorReference(this.fId);
            this.fQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{Otf2CommunicatorsStateProvider.COMMUNICATOR + String.valueOf(this.fId)});
            this.fLocations = locations;
            int i = 0;
            while (i < this.fLocations.size()) {
                ssb.getQuarkRelativeAndAdd(this.fQuark, new String[]{Otf2CommunicatorsStateProvider.RANK + String.valueOf(i)});
                ++i;
            }
            this.fQuarkInitialized = true;
        }

        public void updatePendingLocations(ITmfStateSystemBuilder ssb) {
            if (this.isInitialized()) {
                Long pendingThreads = 0L;
                for (Map.Entry<Long, Long> entry : this.fTimestampsPendingThreads.entrySet()) {
                    Long timestamp = entry.getKey();
                    Long value = entry.getValue();
                    pendingThreads = pendingThreads + value;
                    ssb.modifyAttribute(timestamp.longValue(), (Object)pendingThreads, this.fQuark);
                }
                this.fTimestampsPendingThreads.clear();
            }
        }
    }

    private class CommunicatorsLocation
    extends Location {
        private Communicator fCurrentCommunicator;
        private String fLatestEnteredRegion;
        private long fLatestEnteredTimestamp;
        private boolean fInCommunication;
        private boolean fInIRecvRequest;
        private int fRank;
        private final List<MessageIdentifiers> fSentMessages;
        private final Map<Long, Long> fRequestIdBeginTimestamp;
        private final Deque<IRecvRequest> fIRecvRequests;
        private final Deque<StateSystemUpdateTriplet> fPendingStateSystemUpdates;

        public CommunicatorsLocation(ITmfEvent event) {
            super(event);
            this.fCurrentCommunicator = new Communicator(-1);
            this.fLatestEnteredRegion = "UNKNOWN";
            this.fLatestEnteredTimestamp = 0L;
            this.fInCommunication = false;
            this.fInIRecvRequest = false;
            this.fRank = -1;
            this.fSentMessages = new ArrayList<MessageIdentifiers>();
            this.fRequestIdBeginTimestamp = new HashMap<Long, Long>();
            this.fIRecvRequests = new LinkedList<IRecvRequest>();
            this.fPendingStateSystemUpdates = new LinkedList<StateSystemUpdateTriplet>();
        }

        private void searchAndUpdateIRecvRequest(long requestID, Communicator communicator, int rank) {
            for (IRecvRequest request : this.fIRecvRequests) {
                if (request.fRequestID != requestID) continue;
                request.fCommunicator = communicator;
                request.fRank = rank;
                request.fRequestResolved = true;
                break;
            }
        }

        /*
         * Unable to fully structure code
         */
        private void flushUpdatesUntilUnresolvedRequest() {
            ssb = Otf2CommunicatorsStateProvider.access$0(Otf2CommunicatorsStateProvider.this);
            if (ssb != null) ** GOTO lbl14
            return;
lbl-1000:
            // 1 sources

            {
                firstRequest = this.fIRecvRequests.removeFirst();
                requestCommunicatorQuark = firstRequest.fCommunicator.fQuark;
                requestAssociatedLocationQuark = ssb.getQuarkRelativeAndAdd(requestCommunicatorQuark, new String[]{"Rank " + String.valueOf(firstRequest.fRank)});
                ssb.modifyAttribute(firstRequest.fRequestBeginTimestamp, (Object)firstRequest.fOperationName, requestAssociatedLocationQuark);
                ssb.modifyAttribute(firstRequest.fRequestEndTimestamp, null, requestAssociatedLocationQuark);
                nextRequestTimestamp = this.fIRecvRequests.isEmpty() != false ? 0x7FFFFFFFFFFFFFFFL : this.fIRecvRequests.getFirst().fRequestBeginTimestamp;
                while (!this.fPendingStateSystemUpdates.isEmpty() && this.fPendingStateSystemUpdates.peekFirst().fTimestamp <= nextRequestTimestamp) {
                    triplet = this.fPendingStateSystemUpdates.removeFirst();
                    ssb.modifyAttribute(triplet.fTimestamp, (Object)triplet.fValue, triplet.fQuark);
                }
lbl14:
                // 2 sources

                ** while (!this.fIRecvRequests.isEmpty() && this.fIRecvRequests.getFirst().fRequestResolved)
            }
lbl15:
            // 1 sources

        }

        public void flushAllUpdates(ITmfStateSystemBuilder ssb) {
            for (IRecvRequest request : this.fIRecvRequests) {
                if (!request.fRequestResolved) continue;
                while (!this.fPendingStateSystemUpdates.isEmpty() && this.fPendingStateSystemUpdates.peekFirst().fTimestamp <= request.fRequestBeginTimestamp) {
                    StateSystemUpdateTriplet triplet = this.fPendingStateSystemUpdates.removeFirst();
                    ssb.modifyAttribute(triplet.fTimestamp, (Object)triplet.fValue, triplet.fQuark);
                }
                int requestCommunicatorQuark = request.fCommunicator.fQuark;
                int requestAssociatedLocationQuark = ssb.getQuarkRelativeAndAdd(requestCommunicatorQuark, new String[]{Otf2CommunicatorsStateProvider.RANK + String.valueOf(request.fRank)});
                ssb.modifyAttribute(request.fRequestBeginTimestamp, (Object)request.fOperationName, requestAssociatedLocationQuark);
                ssb.modifyAttribute(request.fRequestEndTimestamp, null, requestAssociatedLocationQuark);
            }
            while (!this.fPendingStateSystemUpdates.isEmpty()) {
                StateSystemUpdateTriplet triplet = this.fPendingStateSystemUpdates.removeFirst();
                ssb.modifyAttribute(triplet.fTimestamp, (Object)triplet.fValue, triplet.fQuark);
            }
        }

        public void enter(ITmfEvent event) {
            String regionName;
            ITmfEventField content = event.getContent();
            this.fLatestEnteredTimestamp = event.getTimestamp().toNanos();
            Integer regionId = (Integer)content.getFieldValue(Integer.class, new String[]{"region"});
            if (regionId == null) {
                return;
            }
            this.fLatestEnteredRegion = regionName = Otf2CommunicatorsStateProvider.this.getRegionNameFromRegionId(regionId);
        }

        public void mpiIRecvRequest(ITmfEvent event) {
            ITmfEventField content = event.getContent();
            Long requestID = (Long)content.getFieldValue(Long.class, new String[]{"requestID"});
            if (requestID == null) {
                return;
            }
            this.fInCommunication = true;
            this.fInIRecvRequest = true;
            this.fRequestIdBeginTimestamp.put(requestID, this.fLatestEnteredTimestamp);
            this.fIRecvRequests.add(new IRecvRequest(this.fLatestEnteredRegion, this.fLatestEnteredTimestamp, requestID));
        }

        public void leave(ITmfEvent event, ITmfStateSystemBuilder ssb) {
            if (this.fInIRecvRequest) {
                IRecvRequest iRecvRequest = this.fIRecvRequests.getLast();
                iRecvRequest.fRequestEndTimestamp = event.getTimestamp().toNanos();
                this.fInIRecvRequest = false;
                return;
            }
            if (this.fInCommunication) {
                int communicatorQuark = this.fCurrentCommunicator.fQuark;
                int associatedLocationQuark = ssb.getQuarkRelativeAndAdd(communicatorQuark, new String[]{Otf2CommunicatorsStateProvider.RANK + String.valueOf(this.fRank)});
                long eventTimestamp = event.getTimestamp().toNanos();
                if (this.fIRecvRequests.isEmpty()) {
                    ssb.modifyAttribute(this.fLatestEnteredTimestamp, (Object)this.fLatestEnteredRegion, associatedLocationQuark);
                    ssb.modifyAttribute(eventTimestamp, null, associatedLocationQuark);
                } else {
                    this.fPendingStateSystemUpdates.add(new StateSystemUpdateTriplet(associatedLocationQuark, this.fLatestEnteredRegion, this.fLatestEnteredTimestamp));
                    this.fPendingStateSystemUpdates.add(new StateSystemUpdateTriplet(associatedLocationQuark, null, eventTimestamp));
                }
                this.fInCommunication = false;
            }
        }

        public void mpiSend(ITmfEvent srcEvent, Communicator communicator) {
            ITmfEventField content = srcEvent.getContent();
            Integer srcRank = Otf2CommunicatorsStateProvider.this.getRank(this.getId(), communicator.fId);
            Integer destRank = (Integer)content.getFieldValue(Integer.class, new String[]{"receiver"});
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (destRank == null || messageTag == null || srcRank == -1) {
                return;
            }
            this.fSentMessages.add(new MessageIdentifiers(communicator.fId, srcRank, destRank, messageTag, srcEvent.getTimestamp().toNanos()));
            this.fCurrentCommunicator = communicator;
            this.fRank = srcRank;
        }

        public void mpiRecv(ITmfEvent srcEvent, Communicator communicator, boolean isBlocking) {
            ITmfEventField content = srcEvent.getContent();
            Integer destRank = Otf2CommunicatorsStateProvider.this.getRank(this.getId(), communicator.fId);
            Integer srcRank = (Integer)content.getFieldValue(Integer.class, new String[]{"sender"});
            Integer messageTag = (Integer)content.getFieldValue(Integer.class, new String[]{"msgTag"});
            if (srcRank == null || messageTag == null || destRank == -1) {
                return;
            }
            CommunicatorsLocation srcLocation = Otf2CommunicatorsStateProvider.this.fMapLocation.get(communicator.fLocations.get(srcRank));
            if (srcLocation == null) {
                return;
            }
            MessageIdentifiers message = new MessageIdentifiers(communicator.fId, srcRank, destRank, messageTag);
            int messageIndex = srcLocation.fSentMessages.indexOf(message);
            MessageIdentifiers sentMessage = srcLocation.fSentMessages.remove(messageIndex);
            Long recvBeginTimestamp = this.fLatestEnteredTimestamp;
            if (!isBlocking) {
                Long requestBeginTimestamp;
                Long requestId = (Long)content.getFieldValue(Long.class, new String[]{"requestID"});
                if (requestId == null) {
                    return;
                }
                this.searchAndUpdateIRecvRequest(requestId, communicator, destRank);
                if (this.fIRecvRequests.getFirst().fRequestID == requestId) {
                    this.flushUpdatesUntilUnresolvedRequest();
                }
                if ((requestBeginTimestamp = this.fRequestIdBeginTimestamp.remove(requestId)) == null) {
                    return;
                }
                recvBeginTimestamp = requestBeginTimestamp;
            }
            Long beginCommunicatorUseTimestamp = Math.min(recvBeginTimestamp, sentMessage.getBeginTimestamp());
            communicator.incrementPendingThreads(beginCommunicatorUseTimestamp, 2L);
            communicator.incrementPendingThreads(sentMessage.getBeginTimestamp(), -1L);
            communicator.incrementPendingThreads(srcEvent.getTimestamp().toNanos(), -1L);
            this.fCurrentCommunicator = communicator;
            this.fRank = destRank;
        }

        private void mpiCollective(ITmfEvent event, Communicator communicator) {
            CollectiveOperationIdentifiers collectiveOperation2;
            long id = this.getId();
            ITmfEventField content = event.getContent();
            Integer operationCode = (Integer)content.getFieldValue(Integer.class, new String[]{"collectiveOp"});
            if (operationCode == null) {
                return;
            }
            Integer root = (Integer)content.getFieldValue(Integer.class, new String[]{"root"});
            if (root == null) {
                return;
            }
            this.fCurrentCommunicator = communicator;
            this.fRank = Otf2CommunicatorsStateProvider.this.getRank(id, communicator.fId);
            for (CollectiveOperationIdentifiers collectiveOperation2 : communicator.fCollectiveOperations) {
                if (!collectiveOperation2.isAssociatedOperation(operationCode, root, id)) continue;
                collectiveOperation2.locationCalledOperation(id, this.fLatestEnteredTimestamp);
                communicator.incrementPendingThreads(event.getTimestamp().toNanos(), -1L);
                if (collectiveOperation2.isOperationDone()) {
                    communicator.incrementPendingThreads(Collections.min(collectiveOperation2.getEnterTimestamps()), communicator.fLocations.size());
                    communicator.fCollectiveOperations.remove(collectiveOperation2);
                }
                return;
            }
            collectiveOperation2 = new CollectiveOperationIdentifiers(operationCode, root, new ArrayList<Long>(communicator.fLocations));
            communicator.fCollectiveOperations.add(collectiveOperation2);
            collectiveOperation2.locationCalledOperation(id, this.fLatestEnteredTimestamp);
            communicator.incrementPendingThreads(event.getTimestamp().toNanos(), -1L);
            if (collectiveOperation2.isOperationDone()) {
                communicator.incrementPendingThreads(Collections.min(collectiveOperation2.getEnterTimestamps()), communicator.fLocations.size());
                communicator.fCollectiveOperations.remove(collectiveOperation2);
            }
        }
    }

    private class IRecvRequest {
        private final String fOperationName;
        private final long fRequestBeginTimestamp;
        private final long fRequestID;
        private Communicator fCommunicator;
        private int fRank;
        private long fRequestEndTimestamp;
        private boolean fRequestResolved;

        public IRecvRequest(String operationName, long requestBeginTimestamp, long requestID) {
            this.fOperationName = operationName;
            this.fRequestBeginTimestamp = requestBeginTimestamp;
            this.fRequestID = requestID;
            this.fCommunicator = new Communicator(-1);
            this.fRank = -1;
            this.fRequestEndTimestamp = 0L;
            this.fRequestResolved = false;
        }
    }

    private class StateSystemUpdateTriplet {
        private final int fQuark;
        private final @Nullable String fValue;
        private final long fTimestamp;

        public StateSystemUpdateTriplet(@Nullable int quark, String value, long timestamp) {
            this.fQuark = quark;
            this.fValue = value;
            this.fTimestamp = timestamp;
        }
    }
}

