/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.callstack.core.base.EdgeStateValue;
import org.eclipse.tracecompass.incubator.callstack.core.base.ICallStackElement;
import org.eclipse.tracecompass.incubator.callstack.core.flamechart.CallStack;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.CallStackDepth;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.ICalledFunction;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.IFlameChartProvider;
import org.eclipse.tracecompass.incubator.callstack.core.instrumented.statesystem.CallStackSeries;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.InstrumentedCallStackElement;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartArrowProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartEntryModel;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.Messages;
import org.eclipse.tracecompass.incubator.internal.callstack.core.palette.FlameDefaultPalette;
import org.eclipse.tracecompass.incubator.internal.callstack.core.palette.FlameWithKernelPalette;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadEntryModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderManager;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.CommonStatusMessage;
import org.eclipse.tracecompass.tmf.core.model.IOutputStyleProvider;
import org.eclipse.tracecompass.tmf.core.model.ITimeElement;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.OutputStyleModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphStateFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphRowModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.symbols.ISymbolProvider;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderManager;
import org.eclipse.tracecompass.tmf.core.symbols.SymbolProviderUtils;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.util.Pair;

public class FlameChartDataProvider
extends AbstractTmfTraceDataProvider
implements ITimeGraphDataProvider<FlameChartEntryModel>,
IOutputStyleProvider {
    public static final String ID = "org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.flamechart";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private static final Logger LOGGER = TraceCompassLog.getLogger(FlameChartDataProvider.class);
    private final Map<Long, FlameChartEntryModel> fEntries = new HashMap<Long, FlameChartEntryModel>();
    private final BiMap<Long, Long> fLinkedEntries = HashBiMap.create();
    private final Collection<ISymbolProvider> fProviders = new ArrayList<ISymbolProvider>();
    private final BiMap<Long, CallStackDepth> fIdToCallstack = HashBiMap.create();
    private final BiMap<Long, ICallStackElement> fIdToElement = HashBiMap.create();
    private final long fTraceId = ENTRY_ID.getAndIncrement();
    private final Map<Long, @NonNull Multimap<@NonNull String, @NonNull Object>> fEntryMetadata = new HashMap<Long, Multimap<String, Object>>();
    private final LoadingCache<Pair<Integer, ICalledFunction>, @Nullable String> fTimeEventNames = Objects.requireNonNull(CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<Pair<Integer, ICalledFunction>, String>(){

        public @Nullable String load(Pair<Integer, ICalledFunction> pidInterval) {
            Integer pid = (Integer)pidInterval.getFirst();
            ICalledFunction interval = (ICalledFunction)pidInterval.getSecond();
            Object nameValue = interval.getSymbol();
            Long address = null;
            String name = null;
            if (nameValue instanceof String) {
                name = (String)nameValue;
                try {
                    address = Long.parseLong(name, 16);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (nameValue instanceof Integer) {
                Integer intValue = (Integer)nameValue;
                name = "0x" + Integer.toUnsignedString(intValue, 16);
                address = intValue.longValue();
            } else if (nameValue instanceof Long) {
                address = (long)((Long)nameValue);
                name = "0x" + Long.toUnsignedString(address, 16);
            }
            if (address != null) {
                name = SymbolProviderUtils.getSymbolText(FlameChartDataProvider.this.fProviders, (int)pid, (long)interval.getStart(), (long)address);
            }
            return name;
        }
    }));
    private final IFlameChartProvider fFcProvider;
    private final String fAnalysisId;
    private final FlameChartArrowProvider fArrowProvider;
    private @Nullable TmfModelResponse<TmfTreeModel<FlameChartEntryModel>> fCached;
    private @Nullable ThreadData fThreadData = null;

    public FlameChartDataProvider(ITmfTrace trace, IFlameChartProvider module, String secondaryId) {
        super(trace);
        this.fFcProvider = module;
        this.fAnalysisId = secondaryId;
        this.fArrowProvider = new FlameChartArrowProvider(trace);
        this.resetFunctionNames((IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TmfModelResponse<List<ITimeGraphArrow>> fetchArrows(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        List<ITmfStateInterval> arrows = this.fArrowProvider.fetchArrows(fetchParameters, monitor);
        if (monitor != null && monitor.isCanceled()) {
            return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
        }
        if (arrows.isEmpty()) {
            return new TmfModelResponse(Collections.emptyList(), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        ArrayList<TimeGraphArrow> tgArrows = new ArrayList<TimeGraphArrow>();
        ArrayList csList = new ArrayList();
        BiMap<Long, CallStackDepth> biMap = this.fIdToCallstack;
        synchronized (biMap) {
            csList.addAll(this.fIdToCallstack.values());
        }
        HashSet<CallStack> callstacks = new HashSet<CallStack>();
        for (CallStackDepth csd : csList) {
            callstacks.add(csd.getCallStack());
        }
        for (ITmfStateInterval interval : arrows) {
            if (monitor != null && monitor.isCanceled()) {
                return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
            }
            EdgeStateValue edge = (EdgeStateValue)((Object)interval.getValue());
            if (edge == null) continue;
            Long src = this.findEntry(callstacks, edge.getSource(), interval.getStartTime());
            Long dst = this.findEntry(callstacks, edge.getDestination(), interval.getEndTime() + 1L);
            if (src == null || dst == null) continue;
            long duration = interval.getEndTime() - interval.getStartTime() + 1L;
            tgArrows.add(new TimeGraphArrow(src.longValue(), dst.longValue(), interval.getStartTime(), duration, edge.getId()));
        }
        return new TmfModelResponse(tgArrows, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Long findEntry(Set<CallStack> callstacks, HostThread hostThread, long ts) {
        for (CallStack callstack : callstacks) {
            HostThread csHt = callstack.getHostThread(ts);
            if (csHt == null || !csHt.equals((Object)hostThread)) continue;
            int currentDepth = callstack.getCurrentDepth(ts);
            CallStackDepth csd = new CallStackDepth(callstack, currentDepth);
            BiMap<Long, CallStackDepth> biMap = this.fIdToCallstack;
            synchronized (biMap) {
                return (Long)this.fIdToCallstack.inverse().get((Object)csd);
            }
        }
        return null;
    }

    public TmfModelResponse<Map<String, String>> fetchTooltip(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameChartDataProvider#fetchTooltip", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
            List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
            if (times == null || times.isEmpty()) {
                return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            BiMap<Long, FlameChartEntryModel> entries = this.getSelectedEntries(fetchParameters);
            if (entries.size() != 1) {
                return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
            }
            Map.Entry<@NonNull K, @NonNull V> entry = entries.entrySet().iterator().next();
            Map<String, String> tooltip = this.getTooltip((Long)entry.getKey(), (FlameChartEntryModel)((Object)entry.getValue()), (Long)times.get(0), monitor);
            return new TmfModelResponse(tooltip, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private @Nullable Map<String, String> getTooltip(Long entryId, FlameChartEntryModel entryModel, Long time, @Nullable IProgressMonitor monitor) {
        switch (entryModel.getEntryType()) {
            case FUNCTION: {
                CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)entryId);
                if (selectedDepth == null) {
                    return null;
                }
                Multimap<CallStackDepth, ISegment> csFunctions = this.fFcProvider.queryCallStacks(Collections.singleton(selectedDepth), Collections.singleton(time));
                Collection functions = csFunctions.get((Object)selectedDepth);
                if (functions.isEmpty()) {
                    return null;
                }
                ISegment next = (ISegment)functions.iterator().next();
                if (!(next instanceof ICalledFunction)) {
                    return null;
                }
                ICalledFunction currentFct = (ICalledFunction)next;
                HashMap<String, String> tooltips = new HashMap<String, String>();
                int threadId = currentFct.getThreadId();
                if (threadId > 0) {
                    tooltips.put(String.valueOf(Messages.FlameChartDataProvider_ThreadId), String.valueOf(threadId));
                }
                Object symbol = currentFct.getSymbol();
                tooltips.put(String.valueOf(Messages.FlameChartDataProvider_Symbol), symbol instanceof Long ? "0x" + Long.toHexString((Long)symbol) : String.valueOf(symbol));
                return tooltips;
            }
            case KERNEL: {
                Long csId = (Long)this.fLinkedEntries.get((Object)entryId);
                if (csId == null) {
                    return null;
                }
                CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)csId);
                if (selectedDepth == null) {
                    return null;
                }
                int threadId = selectedDepth.getCallStack().getThreadId(time);
                ThreadData threadData = this.fThreadData;
                if (threadData == null) {
                    return null;
                }
                return threadData.fetchTooltip(threadId, time, monitor);
            }
        }
        return null;
    }

    public String getId() {
        return "org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.flamechart:" + this.fAnalysisId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getEntryId(CallStackDepth stack) {
        BiMap<Long, CallStackDepth> biMap = this.fIdToCallstack;
        synchronized (biMap) {
            return (Long)this.fIdToCallstack.inverse().computeIfAbsent((Object)stack, q -> ENTRY_ID.getAndIncrement());
        }
    }

    private long getEntryId(ICallStackElement instrumentedCallStackElement) {
        return (Long)this.fIdToElement.inverse().computeIfAbsent((Object)instrumentedCallStackElement, q -> ENTRY_ID.getAndIncrement());
    }

    private long getKernelEntryId(long baseId) {
        return (Long)this.fLinkedEntries.inverse().computeIfAbsent((Object)baseId, id -> ENTRY_ID.getAndIncrement());
    }

    public TmfModelResponse<TmfTreeModel<FlameChartEntryModel>> fetchTree(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        if (this.fCached != null) {
            return this.fCached;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameChartDataProvider#fetchTree", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
            IFlameChartProvider fcProvider = this.fFcProvider;
            boolean complete = fcProvider.isComplete();
            CallStackSeries callstack = fcProvider.getCallStackSeries();
            if (callstack == null) {
                return new TmfModelResponse(null, ITmfResponse.Status.FAILED, CommonStatusMessage.ANALYSIS_INITIALIZATION_FAILED);
            }
            long start = this.getTrace().getStartTime().getValue();
            long end = Math.max(start, fcProvider.getEnd());
            ImmutableList.Builder builder = ImmutableList.builder();
            FlameChartEntryModel traceEntry = new FlameChartEntryModel(this.fTraceId, -1L, Collections.singletonList(this.getTrace().getName()), start, end, FlameChartEntryModel.EntryType.TRACE);
            builder.add((Object)traceEntry);
            FlameChartEntryModel callStackRoot = traceEntry;
            boolean needsKernel = false;
            for (ICallStackElement element : callstack.getRootElements()) {
                if (monitor != null && monitor.isCanceled()) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                needsKernel |= this.processCallStackElement(element, (ImmutableList.Builder<FlameChartEntryModel>)builder, callStackRoot);
            }
            if (needsKernel) {
                this.prepareKernelData(monitor, start);
            }
            ImmutableList tree = builder.build();
            tree.forEach(entry -> {
                FlameChartEntryModel flameChartEntryModel = this.fEntries.put(entry.getId(), (FlameChartEntryModel)((Object)entry));
            });
            for (FlameChartEntryModel model : tree) {
                this.fEntryMetadata.put(model.getId(), model.getMetadata());
            }
            if (complete) {
                TmfModelResponse response;
                this.fCached = response = new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)tree), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                return response;
            }
            return new TmfModelResponse((Object)new TmfTreeModel(Collections.emptyList(), (List)tree), ITmfResponse.Status.RUNNING, CommonStatusMessage.RUNNING);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void prepareKernelData(@Nullable IProgressMonitor monitor, long start) {
        ThreadData data = this.fThreadData;
        if (data != null && data.fStatus.equals((Object)ITmfResponse.Status.COMPLETED)) {
            return;
        }
        Set tracesForHost = TmfTraceManager.getInstance().getTracesForHost(this.getTrace().getHostId());
        for (ITmfTrace trace : tracesForHost) {
            TmfModelResponse threadTreeResp;
            TmfTreeModel threadTree;
            ThreadStatusDataProvider dataProvider = (ThreadStatusDataProvider)DataProviderManager.getInstance().getOrCreateDataProvider(trace, "org.eclipse.tracecompass.internal.analysis.os.linux.core.threadstatus.ThreadStatusDataProvider", ThreadStatusDataProvider.class);
            if (dataProvider == null || (threadTree = (TmfTreeModel)(threadTreeResp = dataProvider.fetchTree(FetchParametersUtils.timeQueryToMap((TimeQueryFilter)new TimeQueryFilter(start, Long.MAX_VALUE, 2)), monitor)).getModel()) == null) continue;
            this.fThreadData = new ThreadData(dataProvider, threadTree.getEntries(), threadTreeResp.getStatus());
            break;
        }
    }

    private boolean processCallStackElement(ICallStackElement element, ImmutableList.Builder<FlameChartEntryModel> builder, FlameChartEntryModel parentEntry) {
        long elementId = this.getEntryId(element);
        boolean needsKernel = false;
        if (element instanceof InstrumentedCallStackElement && element.isLeaf()) {
            InstrumentedCallStackElement finalElement = (InstrumentedCallStackElement)element;
            CallStack callStack = finalElement.getCallStack();
            HostThread hostThread = callStack.getHostThread();
            FlameChartEntryModel entry = new FlameChartEntryModel(elementId, parentEntry.getId(), Collections.singletonList(element.getName()), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.LEVEL, -1, hostThread);
            builder.add((Object)entry);
            int depth = 0;
            while (depth < callStack.getMaxDepth()) {
                FlameChartEntryModel flameChartEntry = new FlameChartEntryModel(this.getEntryId(new CallStackDepth(callStack, depth + 1)), entry.getId(), Collections.singletonList(element.getName()), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.FUNCTION, depth + 1, hostThread);
                builder.add((Object)flameChartEntry);
                if (depth == 0 && callStack.hasKernelStatuses()) {
                    needsKernel = true;
                    builder.add((Object)new FlameChartEntryModel(this.getKernelEntryId(flameChartEntry.getId()), entry.getId(), Collections.singletonList(String.valueOf(Messages.FlameChartDataProvider_KernelStatusTitle)), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.KERNEL, -1, hostThread));
                }
                ++depth;
            }
            return needsKernel;
        }
        FlameChartEntryModel entry = new FlameChartEntryModel(elementId, parentEntry.getId(), Collections.singletonList(element.getName()), parentEntry.getStartTime(), parentEntry.getEndTime(), FlameChartEntryModel.EntryType.LEVEL);
        builder.add((Object)entry);
        for (ICallStackElement child : element.getChildrenElements()) {
            needsKernel |= this.processCallStackElement(child, builder, entry);
        }
        return needsKernel;
    }

    private BiMap<Long, FlameChartEntryModel> getSelectedEntries(Map<String, Object> fetchParameters) {
        HashBiMap selectedEntries = HashBiMap.create();
        List ids = DataProviderParameterUtils.extractSelectedItems(fetchParameters);
        if (ids == null) {
            return selectedEntries;
        }
        for (Long selectedItem : ids) {
            FlameChartEntryModel entryModel = this.fEntries.get(selectedItem);
            if (entryModel == null) continue;
            selectedEntries.put((Object)selectedItem, (Object)entryModel);
        }
        return selectedEntries;
    }

    public TmfModelResponse<TimeGraphModel> fetchRowModel(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (TraceCompassLogUtils.FlowScopeLog scope = new TraceCompassLogUtils.FlowScopeLogBuilder(LOGGER, Level.FINE, "FlameChartDataProvider#fetchRowModel", new Object[0]).setCategory(((Object)((Object)this)).getClass().getSimpleName()).build();){
                BiMap<Long, FlameChartEntryModel> entries = this.getSelectedEntries(fetchParameters);
                List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
                if (times == null) {
                    return new TmfModelResponse(null, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                }
                if (entries.size() == 1 && times.size() == 2) {
                    Map.Entry<@NonNull Long, @NonNull FlameChartEntryModel> entry2 = entries.entrySet().iterator().next();
                    if ((Long)times.get(0) == Long.MIN_VALUE) {
                        List<ITimeGraphRowModel> followEvents = this.getFollowEvent(entry2, (Long)times.get(times.size() - 1), false);
                        TimeGraphModel model = followEvents == null ? null : new TimeGraphModel(followEvents);
                        return new TmfModelResponse((Object)model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                    }
                    if ((Long)times.get(times.size() - 1) == Long.MAX_VALUE) {
                        List<ITimeGraphRowModel> followEvents = this.getFollowEvent(entry2, (Long)times.get(0), true);
                        TimeGraphModel model = followEvents == null ? null : new TimeGraphModel(followEvents);
                        return new TmfModelResponse((Object)model, ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
                    }
                }
                this.addRequiredCallstacks((Map<Long, FlameChartEntryModel>)entries);
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"FlameChartDataProvider#fetchRowModel", (int)2);
                IFlameChartProvider fcProvider = this.fFcProvider;
                boolean complete = fcProvider.isComplete();
                Map<Long, List<ITimeGraphState>> csRows = this.getCallStackRows(fetchParameters, (Map<Long, FlameChartEntryModel>)entries, subMonitor);
                if (csRows == null) {
                    return new TmfModelResponse(null, ITmfResponse.Status.CANCELLED, CommonStatusMessage.TASK_CANCELLED);
                }
                List collect = csRows.entrySet().stream().map(entry -> new TimeGraphRowModel(((Long)entry.getKey()).longValue(), (List)entry.getValue())).collect(Collectors.toList());
                return new TmfModelResponse((Object)new TimeGraphModel(collect), complete ? ITmfResponse.Status.COMPLETED : ITmfResponse.Status.RUNNING, complete ? CommonStatusMessage.COMPLETED : CommonStatusMessage.RUNNING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IndexOutOfBoundsException | TimeRangeException e) {
            return new TmfModelResponse(null, ITmfResponse.Status.FAILED, String.valueOf(e.getMessage()));
        }
    }

    private void addRequiredCallstacks(Map<Long, FlameChartEntryModel> entries) {
        HashMap<Long, FlameChartEntryModel> toAdd = new HashMap<Long, FlameChartEntryModel>();
        for (Long id : entries.keySet()) {
            FlameChartEntryModel entry;
            Long csId = (Long)this.fLinkedEntries.get((Object)id);
            if (csId == null || (entry = this.fEntries.get(csId)) == null) continue;
            toAdd.put(csId, entry);
        }
        entries.putAll(toAdd);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @Nullable Map<Long, List<ITimeGraphState>> getCallStackRows(Map<String, Object> fetchParameters, Map<Long, FlameChartEntryModel> entries, SubMonitor subMonitor) throws IndexOutOfBoundsException, TimeRangeException {
        HashMap<Long, List<ITimeGraphState>> rows = new HashMap<Long, List<ITimeGraphState>>();
        ArrayList<TidInformation> tids = new ArrayList<TidInformation>();
        HashMap<Long, CallStackDepth> csEntries = new HashMap<Long, CallStackDepth>();
        for (Map.Entry<Long, FlameChartEntryModel> entry : entries.entrySet()) {
            CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)entry.getKey());
            if (selectedDepth == null || !entry.getValue().getEntryType().equals((Object)FlameChartEntryModel.EntryType.FUNCTION)) continue;
            csEntries.put(entry.getKey(), selectedDepth);
        }
        List times = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        Collections.sort(times);
        Multimap<CallStackDepth, ISegment> csFunctions = this.fFcProvider.queryCallStacks(csEntries.values(), Objects.requireNonNull(times));
        HashMap<@NonNull Integer, @NonNull Predicate<@NonNull Multimap<@NonNull String, @NonNull Object>>> predicates = new HashMap<Integer, Predicate<Multimap<String, Object>>>();
        @NonNull @NonNull Multimap regexesMap = DataProviderParameterUtils.extractRegexFilter(fetchParameters);
        if (regexesMap != null) {
            predicates.putAll(this.computeRegexPredicate(regexesMap));
        }
        for (Map.Entry entry : csEntries.entrySet()) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            Collection states = csFunctions.get((Object)((CallStackDepth)entry.getValue()));
            Long key = Objects.requireNonNull((Long)entry.getKey());
            ArrayList<ITimeGraphState> eventList = new ArrayList<ITimeGraphState>(states.size());
            states.forEach(state -> {
                ITimeGraphState timeGraphState = this.createTimeGraphState((ISegment)state);
                this.applyFilterAndAddState(eventList, timeGraphState, key, predicates, (IProgressMonitor)subMonitor);
            });
            eventList.sort(Comparator.comparingLong(ITimeElement::getStartTime));
            rows.put((Long)entry.getKey(), eventList);
            Long linked = (Long)this.fLinkedEntries.inverse().get(entry.getKey());
            if (linked == null || !entries.containsKey(linked)) continue;
            tids.addAll(FlameChartDataProvider.getKernelTids((CallStackDepth)entry.getValue(), states, linked));
        }
        for (Long key : entries.keySet()) {
            if (rows.containsKey(key)) continue;
            rows.put(key, Collections.emptyList());
        }
        if (!tids.isEmpty()) {
            rows.putAll(this.getKernelStates(tids, times, predicates, subMonitor));
        }
        subMonitor.worked(1);
        return rows;
    }

    private Map<Long, List<ITimeGraphState>> getKernelStates(List<TidInformation> tids, List<Long> times, Map<Integer, Predicate<Multimap<String, Object>>> predicates, SubMonitor monitor) {
        ThreadData threadData = this.fThreadData;
        if (threadData == null) {
            return Collections.emptyMap();
        }
        List<ThreadEntryModel> tree = threadData.fThreadTree;
        BiMap<Long, Integer> threadModelIds = FlameChartDataProvider.filterThreads(tree, tids);
        SelectionTimeQueryFilter tidFilter = new SelectionTimeQueryFilter(times, (Collection)threadModelIds.keySet());
        TmfModelResponse rowModel = threadData.fThreadDataProvider.fetchRowModel(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)tidFilter), (IProgressMonitor)monitor);
        TimeGraphModel rowModels = (TimeGraphModel)rowModel.getModel();
        if (rowModel.getStatus().equals((Object)ITmfResponse.Status.CANCELLED) || rowModel.getStatus().equals((Object)ITmfResponse.Status.FAILED) || rowModels == null) {
            return Collections.emptyMap();
        }
        return this.mapThreadStates(rowModels.getRows(), threadModelIds, tids, predicates, monitor);
    }

    private Map<Long, List<ITimeGraphState>> mapThreadStates(List<ITimeGraphRowModel> rowModels, BiMap<Long, Integer> threadModelIds, List<TidInformation> tids, Map<Integer, Predicate<Multimap<String, Object>>> predicates, SubMonitor monitor) {
        ImmutableMap statusRows = Maps.uniqueIndex(rowModels, m -> m.getEntryID());
        Long prevId = -1L;
        ArrayList states = null;
        HashMap<Long, List<ITimeGraphState>> kernelStatuses = new HashMap<Long, List<ITimeGraphState>>();
        for (TidInformation tidInfo : tids) {
            Long tidEntryId;
            Long linkedCsEntryId = (Long)this.fLinkedEntries.get((Object)tidInfo.fLinked);
            if (linkedCsEntryId == null) {
                linkedCsEntryId = tidInfo.fLinked;
            }
            if ((tidEntryId = (Long)threadModelIds.inverse().get((Object)tidInfo.fTid.getTid())) == null) continue;
            ITimeGraphRowModel rowModel = (ITimeGraphRowModel)statusRows.get((Object)tidEntryId);
            if (tidInfo.fLinked != prevId || states == null) {
                if (states != null) {
                    kernelStatuses.put(prevId, states);
                }
                states = new ArrayList();
            }
            rowModel.getStates();
            for (ITimeGraphState state : rowModel.getStates()) {
                if (tidInfo.intersects(state)) {
                    ITimeGraphState timeGraphState = tidInfo.sanitize(state);
                    this.applyFilterAndAddState(states, timeGraphState, linkedCsEntryId, predicates, (IProgressMonitor)monitor);
                }
                if (!tidInfo.precedes(state)) break;
            }
            prevId = tidInfo.fLinked;
        }
        if (states != null) {
            kernelStatuses.put(prevId, states);
        }
        return kernelStatuses;
    }

    private static BiMap<Long, Integer> filterThreads(List<ThreadEntryModel> model, List<TidInformation> tids) {
        HashBiMap tidEntries = HashBiMap.create();
        HashSet<Integer> selectedTids = new HashSet<Integer>();
        for (TidInformation tidInfo : tids) {
            selectedTids.add(tidInfo.fTid.getTid());
        }
        for (ThreadEntryModel entryModel : model) {
            if (!selectedTids.contains(entryModel.getThreadId())) continue;
            try {
                tidEntries.put((Object)entryModel.getId(), (Object)entryModel.getThreadId());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return tidEntries;
    }

    private static Collection<TidInformation> getKernelTids(CallStackDepth callStackDepth, Collection<ISegment> states, Long linked) {
        ArrayList<TidInformation> tids = new ArrayList<TidInformation>();
        CallStack callStack = callStackDepth.getCallStack();
        if (!callStack.isTidVariable()) {
            HostThread hostThread = callStack.getHostThread();
            if (hostThread != null) {
                tids.add(new TidInformation(hostThread, Long.MIN_VALUE, Long.MAX_VALUE, linked));
            }
            return tids;
        }
        for (ISegment state : states) {
            ICalledFunction function;
            HostThread hostThread;
            if (!(state instanceof ICalledFunction) || (hostThread = callStack.getHostThread((function = (ICalledFunction)state).getStart())) == null) continue;
            tids.add(new TidInformation(hostThread, function.getStart(), function.getEnd(), linked));
        }
        return tids;
    }

    private ITimeGraphState createTimeGraphState(ISegment state) {
        if (!(state instanceof ICalledFunction)) {
            return new TimeGraphState(state.getStart(), state.getLength(), Integer.MIN_VALUE);
        }
        ICalledFunction function = (ICalledFunction)state;
        Integer pid = function.getProcessId();
        String name = String.valueOf(this.fTimeEventNames.getUnchecked((Object)new Pair((Object)pid, (Object)function)));
        return new TimeGraphState(function.getStart(), function.getLength(), name, FlameDefaultPalette.getInstance().getStyleFor(state));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public void resetFunctionNames(IProgressMonitor monitor) {
        this.fTimeEventNames.invalidateAll();
        Collection<ISymbolProvider> collection = this.fProviders;
        synchronized (collection) {
            @NonNull Collection symbolProviders = SymbolProviderManager.getInstance().getSymbolProviders(this.getTrace());
            SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)"CallStackDataProvider#resetFunctionNames", (int)symbolProviders.size());
            this.fProviders.clear();
            for (ISymbolProvider symbolProvider : symbolProviders) {
                this.fProviders.add(symbolProvider);
                symbolProvider.loadConfiguration((IProgressMonitor)sub);
                sub.worked(1);
            }
        }
    }

    private @Nullable List<ITimeGraphRowModel> getFollowEvent(Map.Entry<Long, FlameChartEntryModel> entry, long time, boolean forward) {
        FlameChartEntryModel value = Objects.requireNonNull(entry.getValue());
        switch (value.getEntryType()) {
            case FUNCTION: {
                CallStackDepth selectedDepth = (CallStackDepth)this.fIdToCallstack.get((Object)entry.getKey());
                if (selectedDepth == null) {
                    return null;
                }
                ITmfStateInterval nextDepth = selectedDepth.getCallStack().getNextDepth(time, forward);
                if (nextDepth == null) {
                    return null;
                }
                Object depthVal = nextDepth.getValue();
                int depth = depthVal instanceof Number ? ((Number)depthVal).intValue() : 0;
                TimeGraphState state = new TimeGraphState(nextDepth.getStartTime(), nextDepth.getEndTime() - nextDepth.getStartTime(), depth);
                TimeGraphRowModel row = new TimeGraphRowModel(entry.getKey().longValue(), Collections.singletonList(state));
                return Collections.singletonList(row);
            }
            case KERNEL: {
                break;
            }
            default: {
                return null;
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Multimap<@NonNull String, @NonNull Object> getFilterData(long entryId, long time, @Nullable IProgressMonitor monitor) {
        @NonNull @NonNull Multimap data = ITimeGraphStateFilter.mergeMultimaps((Multimap[])new Multimap[]{super.getFilterData(entryId, time, monitor), this.fEntryMetadata.getOrDefault(entryId, (Multimap<String, Object>)ImmutableMultimap.of())});
        FlameChartEntryModel entryModel = this.fEntries.get(entryId);
        if (entryModel == null) {
            return data;
        }
        Map<String, String> tooltip = this.getTooltip(entryId, entryModel, time, monitor);
        if (tooltip == null) {
            return data;
        }
        for (Map.Entry<String, String> entry : tooltip.entrySet()) {
            data.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        return data;
    }

    public TmfModelResponse<OutputStyleModel> fetchStyle(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Map<String, OutputElementStyle> styles = FlameWithKernelPalette.getInstance().getStyles();
        return new TmfModelResponse((Object)new OutputStyleModel(styles), ITmfResponse.Status.COMPLETED, CommonStatusMessage.COMPLETED);
    }

    private static class ThreadData {
        private final ThreadStatusDataProvider fThreadDataProvider;
        private final List<ThreadEntryModel> fThreadTree = new ArrayList<ThreadEntryModel>();
        private final ITmfResponse.Status fStatus;

        public ThreadData(ThreadStatusDataProvider dataProvider, List<TimeGraphEntryModel> threadTree, ITmfResponse.Status status) {
            this.fThreadDataProvider = dataProvider;
            for (TimeGraphEntryModel model : threadTree) {
                if (!(model instanceof ThreadEntryModel)) continue;
                this.fThreadTree.add((ThreadEntryModel)model);
            }
            this.fStatus = status;
        }

        public @Nullable Map<String, String> fetchTooltip(int threadId, long time, @Nullable IProgressMonitor monitor) {
            for (ThreadEntryModel entry : this.fThreadTree) {
                if (entry.getThreadId() != threadId || entry.getStartTime() > time || entry.getEndTime() < time) continue;
                TmfModelResponse tooltip = this.fThreadDataProvider.fetchTooltip(FetchParametersUtils.selectionTimeQueryToMap((SelectionTimeQueryFilter)new SelectionTimeQueryFilter(Collections.singletonList(time), Collections.singleton(entry.getId()))), monitor);
                return (Map)tooltip.getModel();
            }
            return null;
        }
    }

    private static class TidInformation {
        private final HostThread fTid;
        private final long fStart;
        private final long fEnd;
        private final Long fLinked;

        public TidInformation(HostThread hostThread, long start, long end, Long linked) {
            this.fTid = hostThread;
            this.fStart = start;
            this.fEnd = end;
            this.fLinked = linked;
        }

        public boolean intersects(ITimeGraphState state) {
            return state.getStartTime() <= this.fEnd && state.getStartTime() + state.getDuration() >= this.fStart;
        }

        public boolean precedes(ITimeGraphState state) {
            return state.getStartTime() + state.getDuration() < this.fEnd;
        }

        public ITimeGraphState sanitize(ITimeGraphState state) {
            if (state.getStartTime() < this.fStart || state.getStartTime() + state.getDuration() > this.fEnd) {
                long start = Math.max(state.getStartTime(), this.fStart);
                long end = Math.min(state.getStartTime() + state.getDuration(), this.fEnd);
                return new TimeGraphState(start, end - start, state.getLabel(), state.getStyle());
            }
            return state;
        }
    }
}

