/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model;

import java.util.HashSet;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;

public final class VirtualMachine {
    private static final int UNKNOWN = 0;
    private static final int HOST = 1;
    private static final int GUEST = 2;
    private static final int CONTAINER = 4;
    private long fVmUid;
    private final String fHostId;
    private int fType;
    private final String fTraceName;
    private @Nullable VirtualMachine fParent;
    private HashSet<VirtualMachine> fChildren = new HashSet();
    private HashSet<HostThread> fThreadsWaitingForNextLayer = new HashSet();
    private HashSet<HostThread> fThreadsReadyForNextLayer = new HashSet();

    public static VirtualMachine newUnknownMachine(String hostId, String traceName) {
        return new VirtualMachine(0, hostId, -1L, traceName);
    }

    public static VirtualMachine newHostMachine(String hostId, String traceName) {
        return new VirtualMachine(1, hostId, -1L, traceName);
    }

    public static VirtualMachine newGuestMachine(long uid, String hostId, String traceName) {
        return new VirtualMachine(2, hostId, uid, traceName);
    }

    public static VirtualMachine newContainerMachine(long uid, String hostId, String traceName) {
        return new VirtualMachine(4, hostId, uid, traceName);
    }

    private VirtualMachine(int type, String hostId, long uid, String traceName) {
        this.fType = type;
        this.fVmUid = uid;
        this.fHostId = hostId;
        this.fTraceName = traceName;
        this.fParent = null;
    }

    public boolean isGuest() {
        return (this.fType & 2) == 2;
    }

    public void setGuest(long uid) {
        this.fType |= 2;
        this.fVmUid = uid;
    }

    public boolean isHost() {
        return (this.fType & 1) == 1;
    }

    public void setHost() {
        this.fType |= 1;
    }

    public boolean isContainer() {
        return (this.fType & 4) == 4;
    }

    public void setContainer() {
        this.fType |= 4;
    }

    public long getVmUid() {
        return this.fVmUid;
    }

    public String getHostId() {
        return this.fHostId;
    }

    public String getTraceName() {
        return this.fTraceName;
    }

    public String toString() {
        return "VirtualMachine: " + this.fHostId;
    }

    public HashSet<VirtualMachine> getChildren() {
        return this.fChildren;
    }

    public void addChild(VirtualMachine child) {
        this.fChildren.add(child);
    }

    public int getType() {
        return this.fType;
    }

    public @Nullable VirtualMachine getParent() {
        return this.fParent;
    }

    public void setParent(VirtualMachine parent) {
        this.fParent = parent;
    }

    public void addThreadWaitingForNextLayer(HostThread hostThread) {
        this.fThreadsWaitingForNextLayer.add(hostThread);
        this.fThreadsReadyForNextLayer.remove(hostThread);
    }

    public boolean isThreadWaitingForNextLayer(HostThread hostThread) {
        return this.fThreadsWaitingForNextLayer.contains(hostThread);
    }

    public void makeThreadReadyForNextLayer(HostThread hostThread) {
        if (this.fThreadsWaitingForNextLayer.remove(hostThread)) {
            this.fThreadsReadyForNextLayer.add(hostThread);
        }
    }

    public boolean isThreadReadyForNextLayer(HostThread hostThread) {
        return this.fThreadsReadyForNextLayer.contains(hostThread);
    }

    public void removeThreadFromReadyForNextLayerSet(HostThread hostThread) {
        this.fThreadsReadyForNextLayer.remove(hostThread);
    }
}

