/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceLocation;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.context.BinaryFTraceLocationInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.event.BinaryFTraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceCPUSectionIterator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceReader;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.layout.GenericFtraceEventLayout;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.BinaryFTrace;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;

public class BinaryFTraceIterator
extends BinaryFTraceReader
implements ITmfContext,
Comparable<BinaryFTraceIterator> {
    private static final Comparator<BinaryFTraceIterator> COMPARATOR = Comparator.comparing(BinaryFTraceIterator::getRank);
    private static final String SYS_ENTER_EVENT_NAME = "sys_enter";
    private static final String SYS_EXIT_EVENT_NAME = "sys_exit";
    private final @NonNull BinaryFTrace fTrace;
    private BinaryFTraceLocation fCurLocation;
    private long fCurRank;
    private BinaryFTraceLocation fPreviousLocation;
    private GenericFtraceEvent fPreviousEvent;
    public static final BinaryFTraceLocation NULL_LOCATION = new BinaryFTraceLocation(BinaryFTraceLocation.INVALID_LOCATION);

    public BinaryFTraceIterator(BinaryFTraceHeaderInfo headerInfo, @NonNull BinaryFTrace ftrace) throws IOException {
        super(headerInfo);
        this.fTrace = ftrace;
        if (this.hasMoreEvents()) {
            this.skipToFirstValidEvent();
            this.fCurLocation = new BinaryFTraceLocation(ftrace.getStartTime());
            this.fCurRank = 0L;
        } else {
            this.setUnknownLocation();
        }
    }

    public synchronized GenericFtraceEvent getCurrentEvent() throws IOException {
        BinaryFTraceCPUSectionIterator top = super.getPrio().peek();
        if (top != null) {
            if (!this.fCurLocation.equals((Object)this.fPreviousLocation)) {
                this.fPreviousLocation = this.fCurLocation;
                BinaryFTraceEvent event = top.getCurrentEvent();
                if (event != null) {
                    this.fPreviousEvent = this.parseEvent(event);
                }
            }
            return this.fPreviousEvent;
        }
        return null;
    }

    private GenericFtraceEvent parseEvent(BinaryFTraceEvent event) {
        int tgidNumeric;
        Integer pid = -1;
        Integer cpu = event.getCpu();
        Long timestampInNano = event.getTimeSinceBoot();
        String name = BinaryFTraceIterator.eventNameRewrite(event.getEventName());
        Object commonPidField = event.getFields().getOrDefault("common_pid", null);
        if (commonPidField != null) {
            pid = ((Long)commonPidField).intValue();
        }
        Integer tid = pid;
        Object tgidField = event.getFields().getOrDefault("tgid", null);
        if (tgidField != null && (tgidNumeric = ((Long)tgidField).intValue()) != pid) {
            pid = tgidNumeric;
        }
        HashMap<@NonNull String, @NonNull Object> fields = new HashMap<String, Object>();
        for (Map.Entry<String, Object> field : event.getFields().entrySet()) {
            String key = field.getKey();
            Object value = field.getValue();
            if (value == null || key.startsWith("common_")) continue;
            if (key.equals("parent_pid") && name.equals(GenericFtraceEventLayout.getInstance().eventSchedProcessFork())) {
                key = "pid";
            }
            fields.put(key, value);
        }
        GenericFtraceField parsedEvent = new GenericFtraceField(name, cpu, timestampInNano, pid, tid, fields);
        return new GenericFtraceEvent((ITmfTrace)this.fTrace, this.fCurRank, parsedEvent);
    }

    public void dispose() {
        this.close();
    }

    public synchronized boolean seek(BinaryFTraceLocationInfo ctfLocationData) throws IOException {
        GenericFtraceEvent currentEvent;
        long time;
        if (ctfLocationData.equals(BinaryFTraceLocation.INVALID_LOCATION)) {
            this.fCurLocation = NULL_LOCATION;
            return false;
        }
        if (this.fCurLocation.getLocationInfo().equals(ctfLocationData)) {
            return super.hasMoreEvents();
        }
        this.fCurLocation = new BinaryFTraceLocation(ctfLocationData);
        long seekToTimestamp = ctfLocationData.getTimestamp();
        boolean seekSuccess = this.seek(seekToTimestamp);
        long index = this.positionIteratorByIndex(seekToTimestamp, ctfLocationData.getIndex());
        boolean bl = seekSuccess = seekSuccess && index != -1L;
        this.fCurLocation = seekSuccess ? new BinaryFTraceLocation(new BinaryFTraceLocationInfo(time, (time = ((ITmfEvent)Objects.requireNonNull(currentEvent = this.getCurrentEvent())).getTimestamp().getValue()) != seekToTimestamp ? 0L : index)) : NULL_LOCATION;
        return seekSuccess;
    }

    @Override
    public boolean seek(long timestamp) {
        boolean seekSuccess = false;
        try {
            seekSuccess = timestamp < 0L ? super.seek(0L) : super.seek(timestamp);
            seekSuccess = this.skipRawSystemEvents() && seekSuccess;
        }
        catch (Exception e) {
            Activator.getInstance().logInfo(e.getMessage(), (Throwable)e);
            seekSuccess = false;
        }
        return seekSuccess;
    }

    private long positionIteratorByIndex(long timestamp, long indexToSeek) throws IOException {
        boolean success = true;
        long currentIndex = 0L;
        GenericFtraceEvent currentEvent = this.getCurrentEvent();
        while (currentEvent != null && currentIndex < indexToSeek) {
            if (timestamp >= ((ITmfEvent)Objects.requireNonNull(currentEvent)).getTimestamp().getValue()) {
                ++currentIndex;
            } else {
                currentIndex = 0L;
                break;
            }
            success = this.advance();
            currentEvent = this.getCurrentEvent();
        }
        if (!success) {
            return -1L;
        }
        return currentIndex;
    }

    @Override
    public boolean advance() throws IOException {
        boolean readNextEventSuccess = this.readNextEvent();
        return readNextEventSuccess && this.skipRawSystemEvents();
    }

    private boolean readNextEvent() throws IOException {
        boolean hasMoreEvents = false;
        try {
            hasMoreEvents = super.advance();
        }
        catch (Exception ex) {
            Activator.getInstance().logInfo(ex.getMessage(), (Throwable)ex);
        }
        if (hasMoreEvents) {
            long timestampValue;
            long timestamp = this.fCurLocation.getLocationInfo().getTimestamp();
            if (timestamp == (timestampValue = this.getCurrentTimestamp())) {
                long index = this.fCurLocation.getLocationInfo().getIndex();
                this.fCurLocation = new BinaryFTraceLocation(timestampValue, index + 1L);
            } else {
                this.fCurLocation = new BinaryFTraceLocation(timestampValue, 0L);
            }
        } else {
            this.fCurLocation = NULL_LOCATION;
        }
        return hasMoreEvents;
    }

    private boolean skipRawSystemEvents() throws IOException {
        GenericFtraceEvent event = this.getCurrentEvent();
        boolean ret = true;
        while (BinaryFTraceIterator.isRawSystemEvent(event)) {
            ret = this.readNextEvent();
            event = this.getCurrentEvent();
        }
        return ret;
    }

    private boolean skipToFirstValidEvent() throws IOException {
        boolean initTrace = false;
        if (this.fCurLocation == null) {
            initTrace = true;
            this.fCurLocation = new BinaryFTraceLocation(this.fTrace.getStartTime());
            this.fCurRank = 0L;
        }
        boolean ret = this.skipRawSystemEvents();
        if (initTrace) {
            this.fCurLocation = null;
        }
        return ret;
    }

    private static boolean isRawSystemEvent(GenericFtraceEvent event) {
        return event.getName().equals(SYS_ENTER_EVENT_NAME) || event.getName().equals(SYS_EXIT_EVENT_NAME);
    }

    private static String eventNameRewrite(@Nullable String name) {
        String newName;
        if (name == null) {
            return "";
        }
        if (name.startsWith("sys_exit_")) {
            return "exit_syscall";
        }
        if (name.startsWith("sys_enter_") && (newName = name.replaceFirst("sys_enter_", "sys_")) != null) {
            return newName;
        }
        return name;
    }

    public synchronized long getCurrentTimestamp() throws IOException {
        BinaryFTraceEvent currentEvent;
        BinaryFTraceCPUSectionIterator top = super.getPrio().peek();
        if (top != null && (currentEvent = top.getCurrentEvent()) != null) {
            return currentEvent.getTimeSinceBoot();
        }
        return 0L;
    }

    private void setUnknownLocation() {
        this.fCurLocation = NULL_LOCATION;
        this.fCurRank = -1L;
    }

    public long getRank() {
        return this.fCurRank;
    }

    public void increaseRank() {
        if (this.hasValidRank()) {
            ++this.fCurRank;
        }
    }

    public boolean hasValidRank() {
        return this.getRank() >= 0L;
    }

    public void setRank(long rank) {
        this.fCurRank = rank;
    }

    public void setLocation(ITmfLocation location) {
        try {
            this.seek(((BinaryFTraceLocation)location).getLocationInfo());
            this.fCurLocation = (BinaryFTraceLocation)location;
        }
        catch (Exception ex) {
            Activator.getInstance().logError("There is an error setting the location of the iterator");
        }
    }

    public BinaryFTraceLocation getLocation() {
        return this.fCurLocation;
    }

    @Override
    public int compareTo(BinaryFTraceIterator o) {
        return COMPARATOR.compare(this, o);
    }
}

