/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.Utils;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class DeleteFileChange
extends AbstractDeleteChange {
    private final IPath fPath;
    private final boolean fIsExecuteChange;

    public DeleteFileChange(IFile file, boolean executeChange) {
        Assert.isNotNull((Object)file, (String)"file");
        this.fPath = Utils.getResourcePath((IResource)file);
        this.fIsExecuteChange = executeChange;
    }

    private IFile getFile() {
        return Utils.getFile(this.fPath);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteFileChange_1, this.fPath.lastSegment());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(pm, 0);
        }
        return super.isValid(pm, 3);
    }

    public Object getModifiedElement() {
        return this.getFile();
    }

    @Override
    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        IFile file = this.getFile();
        Assert.isNotNull((Object)file);
        Assert.isTrue((boolean)file.exists());
        pm.beginTask("", 3);
        DeleteFileChange.saveFileIfNeeded(file, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)file);
        file.delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        resourceDescription.recordStateFromHistory((IResource)file, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.done();
        return new UndoDeleteResourceChange(resourceDescription);
    }
}

