/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands;

import com.google.common.collect.ImmutableList;
import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.AttachReturnCode;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.IRelayResponse;
import org.eclipse.tracecompass.internal.lttng2.control.core.relayd.commands.StreamResponse;

public class AttachSessionResponse
implements IRelayResponse {
    private static final int SIZE = 8;
    private final AttachReturnCode fStatus;
    private final int fStreamsCount;
    private final List<StreamResponse> fStreamList;

    public AttachSessionResponse(DataInputStream inNet) throws IOException {
        byte[] data = new byte[8];
        inNet.readFully(data, 0, 8);
        ByteBuffer bb = ByteBuffer.wrap(data);
        bb.order(ByteOrder.BIG_ENDIAN);
        this.fStatus = AttachReturnCode.values()[bb.getInt() - 1];
        this.fStreamsCount = bb.getInt();
        ImmutableList.Builder streamResponses = ImmutableList.builder();
        int i = 0;
        while (i < this.getNbStreams()) {
            streamResponses.add((Object)new StreamResponse(inNet));
            ++i;
        }
        this.fStreamList = streamResponses.build();
    }

    public AttachReturnCode getStatus() {
        return this.fStatus;
    }

    public int getNbStreams() {
        return this.fStreamsCount;
    }

    public List<StreamResponse> getStreamList() {
        return this.fStreamList;
    }
}

