/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros2.core.trace;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros2.core.trace.layout.IRos2EventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;
import org.eclipse.tracecompass.tmf.ctf.core.event.CtfTmfEventFactory;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTmfTrace;
import org.eclipse.tracecompass.tmf.ctf.core.trace.CtfTraceValidationStatus;

public class Ros2Trace
extends CtfTmfTrace {
    private static final int CONFIDENCE = 101;
    private static final @NonNull Collection<ITmfEventAspect<?>> ROS_ASPECTS;
    private @NonNull Collection<ITmfEventAspect<?>> fRos2TraceAspects = ImmutableSet.copyOf(ROS_ASPECTS);
    private @Nullable IRos2EventLayout fLayout = null;

    static {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll((Iterable)CtfTmfTrace.CTF_ASPECTS).build();
        ROS_ASPECTS = builder.build();
    }

    public Ros2Trace() {
        super(CtfTmfEventFactory.instance());
    }

    protected Ros2Trace(@NonNull CtfTmfEventFactory factory) {
        super(factory);
    }

    public @NonNull IRos2EventLayout getEventLayout() {
        IRos2EventLayout layout = this.fLayout;
        if (layout == null) {
            throw new IllegalStateException("Cannot get the layout of a non-initialized trace!");
        }
        return layout;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> eventType) throws TmfTraceException {
        super.initTrace(resource, path, eventType);
        this.fLayout = Ros2Trace.getLayout();
    }

    private static @NonNull IRos2EventLayout getLayout() {
        return Objects.requireNonNull(IRos2EventLayout.getDefault());
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        return this.fRos2TraceAspects;
    }

    public IStatus validate(IProject project, String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof CtfTraceValidationStatus) {
            Collection eventNames = ((CtfTraceValidationStatus)status).getEventNames();
            if (eventNames.stream().noneMatch(event -> event.startsWith("ros2:"))) {
                return new Status(4, "org.eclipse.tracecompass.incubator.ros2.core", "The trace is not a ROS 2 trace.");
            }
            int conf = 101;
            conf = (int)((long)conf + eventNames.stream().filter(eventName -> Ros2Trace.getLayout().getEventNames().contains(eventName)).count());
            return new TraceValidationStatus(conf, "org.eclipse.tracecompass.incubator.ros2.core");
        }
        return status;
    }
}

