/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.uftrace.core.analysis;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.event.aspect.LinuxTidAspect;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.DatEvent;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.UfEventType;
import org.eclipse.tracecompass.incubator.internal.uftrace.core.trace.Uftrace;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.MultiAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UfCallstackProvider
extends CallStackStateProvider {
    private final ITmfEventAspect<Integer> fTidAspect;
    private final ITmfEventAspect<Integer> fPidAspect;

    public UfCallstackProvider(@NonNull ITmfTrace trace) {
        super(trace);
        this.fTidAspect = MultiAspect.create((Iterable)TmfTraceUtils.getEventAspects((ITmfTrace)trace, LinuxTidAspect.class), LinuxTidAspect.class);
        this.fPidAspect = MultiAspect.create((Iterable)TmfTraceUtils.getEventAspects((ITmfTrace)trace, Uftrace.PidAspect.class), Uftrace.PidAspect.class);
    }

    public int getVersion() {
        return 3;
    }

    public @NonNull CallStackStateProvider getNewInstance() {
        return new UfCallstackProvider(this.getTrace());
    }

    protected boolean considerEvent(@NonNull ITmfEvent event) {
        return true;
    }

    protected @Nullable ITmfStateValue functionEntry(@NonNull ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Object payload = content.getValue();
        if (payload instanceof DatEvent) {
            DatEvent ev = (DatEvent)payload;
            if (event.getType().equals((Object)UfEventType.ENTRY)) {
                return TmfStateValue.newValueLong((long)ev.getAddress());
            }
        }
        return null;
    }

    protected @Nullable ITmfStateValue functionExit(@NonNull ITmfEvent event) {
        ITmfEventField content = event.getContent();
        Object payload = content.getValue();
        if (payload instanceof DatEvent) {
            DatEvent ev = (DatEvent)payload;
            if (event.getType().equals((Object)UfEventType.EXIT)) {
                return TmfStateValue.newValueLong((long)ev.getAddress());
            }
        }
        return null;
    }

    protected int getProcessId(@NonNull ITmfEvent event) {
        Integer resolve = (Integer)this.fPidAspect.resolve(event);
        return resolve == null ? -1 : resolve;
    }

    protected long getThreadId(@NonNull ITmfEvent event) {
        Integer resolve = (Integer)this.fTidAspect.resolve(event);
        return resolve == null ? -1L : resolve.longValue();
    }
}

