/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.webapp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;

public class OutputElementStyleSerializer
extends StdSerializer<OutputElementStyle> {
    private static final long serialVersionUID = 8663734251280456250L;

    public OutputElementStyleSerializer() {
        super(OutputElementStyle.class);
    }

    public void serialize(@NonNull OutputElementStyle value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("parentKey", value.getParentKey());
        gen.writeObjectFieldStart("values");
        for (Map.Entry entry : value.getStyleValues().entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Long) {
                Long longValue = (Long)entryValue;
                if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) continue;
                gen.writeFieldName((String)entry.getKey());
                gen.writeNumber(longValue.intValue());
                continue;
            }
            if (!(entryValue instanceof String) && !(entryValue instanceof Number)) continue;
            gen.writeFieldName((String)entry.getKey());
            gen.writeObject(entryValue);
        }
        gen.writeEndObject();
        gen.writeEndObject();
    }
}

