/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views.queues;

import java.util.Iterator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.queues.RosQueuesDataProvider;
import org.eclipse.tracecompass.incubator.internal.ros.ui.actions.RosFollowMessageAction;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.AbstractRosView;
import org.eclipse.tracecompass.incubator.internal.ros.ui.views.queues.RosQueuesPresentationProvider;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;

public class RosQueuesView
extends AbstractRosView {
    public static final String ID_SUFFIX = "queues";
    private RosFollowMessageAction fFollowMessageAction = null;

    public RosQueuesView() {
        super(ID_SUFFIX, new RosQueuesPresentationProvider(), RosQueuesDataProvider.getFullDataProviderId());
        this.setFilterColumns(new String[]{""});
        this.setFilterLabelProvider(new RosViewFilterLabelProvider());
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        this.fFollowMessageAction = new RosFollowMessageAction((TmfView)this, this.getTimeGraphViewer());
        this.fFollowMessageAction.setEnabled(false);
        manager.appendToGroup("additions", (IAction)this.fFollowMessageAction);
        manager.appendToGroup("additions", (IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @TmfSignalHandler
    public synchronized void selection(TmfSelectionRangeUpdatedSignal signal) {
        this.updateFollowMessageAction(signal.getSource());
    }

    private void updateFollowMessageAction(Object source) {
        if (this.fFollowMessageAction != null) {
            boolean isValid = false;
            ITimeGraphEntry selection = this.getTimeGraphViewer().getSelection();
            if (selection != null && source == this) {
                ITimeEvent event = RosQueuesView.getMessageReferenceEvent(selection, this.getTimeGraphViewer().getSelectionBegin());
                isValid = event != null && event.getLabel() != null;
            }
            this.fFollowMessageAction.setEnabled(isValid);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static ITimeEvent getMessageReferenceEvent(ITimeGraphEntry selectedEntry, long timestamp) {
        ITimeGraphEntry parent = selectedEntry.getParent();
        if (parent == null || !parent.getName().equals("queue")) {
            return null;
        }
        ITimeEvent refEvent = null;
        @NonNull Iterator timeEventsIt = selectedEntry.getTimeEventsIterator();
        while (timeEventsIt.hasNext()) {
            ITimeEvent event = (ITimeEvent)timeEventsIt.next();
            long duration = event.getDuration();
            long time = event.getTime();
            if (duration > 0L && time <= timestamp && timestamp < time + duration) {
                refEvent = event;
                break;
            }
            if (time > timestamp) break;
        }
        return refEvent;
    }

    public static String getFullViewId() {
        return "org.eclipse.tracecompass.incubator.ros.ui.views.queues";
    }

    private static class RosViewFilterLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private RosViewFilterLabelProvider() {
        }
    }
}

