/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.poll.distribution.analysis;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.dpdk.core.trace.DpdkTrace;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.analysis.DpdkEthdevEventLayout;
import org.eclipse.tracecompass.incubator.internal.dpdk.core.ethdev.poll.distribution.analysis.Messages;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiGenericAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiAnalysis;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiResultTable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableClass;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiLongNumber;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimeRange;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiTimestamp;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfContentFieldAspect;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterMatchesNode;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DpdkPollDistributionAnalysis
extends LamiAnalysis {
    private static final long PROGRESS_INTERVAL = 1023L;
    private static final int MEMORY_SANITY_LIMIT = 40000;
    private final DpdkEthdevEventLayout fLayout = new DpdkEthdevEventLayout();

    public DpdkPollDistributionAnalysis() {
        super(Objects.requireNonNull(Messages.EthdevPollDistribution_AnalysisName), false, trace -> true, Collections.emptyList());
    }

    protected synchronized void initialize() {
    }

    public boolean canExecute(ITmfTrace trace) {
        if (trace instanceof DpdkTrace) {
            return ((DpdkTrace)trace).validate(null, trace.getPath()).isOK();
        }
        return false;
    }

    private static int workRemaining(ITmfTrace trace) {
        return (int)Math.min(trace.getNbEvents() / 1024L, Integer.MAX_VALUE);
    }

    public List<LamiResultTable> execute(ITmfTrace trace, @Nullable TmfTimeRange timeRange, String extraParamsString, IProgressMonitor monitor) throws CoreException {
        AtomicLong done = new AtomicLong();
        TreeMap<String, Map<Integer, Long>> pollCountPerQueue = new TreeMap<String, Map<Integer, Long>>();
        TmfTimeRange adjustedTimeRange = timeRange == null ? TmfTimeRange.ETERNITY : timeRange;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Objects.requireNonNull(Messages.EthdevPollDistribution_AnalysisName), (int)DpdkPollDistributionAnalysis.workRemaining(trace));
        TmfFilterMatchesNode filter = new TmfFilterMatchesNode(null);
        filter.setEventAspect((ITmfEventAspect)new TmfContentFieldAspect(Objects.requireNonNull(Messages.EthdevPollDistribution_CountLabel), new String[]{this.fLayout.fieldPortId()}));
        filter.setRegex(extraParamsString);
        Predicate<ITmfEvent> filterPred = event -> extraParamsString.isEmpty() || filter.matches(event);
        TmfEventRequest eventRequest = this.createEventRequest(trace, adjustedTimeRange, filterPred, pollCountPerQueue, subMonitor, done);
        trace.sendRequest((ITmfEventRequest)eventRequest);
        try {
            eventRequest.waitForCompletion();
            return this.convertToLamiTables(adjustedTimeRange, pollCountPerQueue);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Collections.emptyList();
        }
    }

    private TmfEventRequest createEventRequest(final ITmfTrace trace, TmfTimeRange timeRange, final Predicate<ITmfEvent> filterPredicate, final Map<String, Map<Integer, Long>> pollAspectCounts, final SubMonitor monitor, final AtomicLong nbProcessevents) {
        return new TmfEventRequest(ITmfEvent.class, timeRange, 0L, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.BACKGROUND){

            public void handleData(ITmfEvent event) {
                if (monitor.isCanceled()) {
                    this.cancel();
                    return;
                }
                DpdkPollDistributionAnalysis.this.processEvent(event, filterPredicate, pollAspectCounts);
                if ((nbProcessevents.incrementAndGet() & 0x3FFL) == 0L) {
                    monitor.setWorkRemaining(DpdkPollDistributionAnalysis.workRemaining(trace));
                    monitor.worked(1);
                    monitor.setTaskName(String.format("DPDK Polls Distribution Analysis (%s events processed)", NumberFormat.getInstance().format(nbProcessevents.get())));
                }
            }
        };
    }

    private void processEvent(ITmfEvent event, Predicate<ITmfEvent> filterPredicate, Map<String, Map<Integer, Long>> pollAspectCounts) {
        if (event.getName().equals(this.fLayout.eventEthdevRxBurstNonEmpty()) && filterPredicate.test(event)) {
            String queueName;
            Map dataSet;
            Integer nbRxPkts = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldNbRxPkts()});
            Integer portId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldPortId()});
            Integer queueId = (Integer)event.getContent().getFieldValue(Integer.class, new String[]{this.fLayout.fieldQueueId()});
            if (nbRxPkts != null && portId != null && queueId != null && (dataSet = pollAspectCounts.computeIfAbsent(queueName = "P" + String.valueOf(portId) + "/Q" + String.valueOf(queueId), k -> new HashMap())).size() < 40000) {
                dataSet.merge(nbRxPkts, 1L, (v1, v2) -> v1 + v2);
            }
        }
    }

    private List<LamiResultTable> convertToLamiTables(TmfTimeRange timeRange, Map<String, Map<Integer, Long>> pollCountPerQueue) {
        ArrayList<LamiResultTable> results = new ArrayList<LamiResultTable>();
        for (Map.Entry<String, Map<Integer, Long>> entry : pollCountPerQueue.entrySet()) {
            String queueName = Objects.requireNonNull(entry.getKey());
            Map<Integer, Long> dataSet = Objects.requireNonNull(entry.getValue());
            List tableEntries = dataSet.entrySet().stream().map(e -> new LamiTableEntry(Arrays.asList(new LamiData[]{new LamiString(Objects.requireNonNull((Integer)e.getKey()).toString()), new LamiLongNumber(Objects.requireNonNull((Long)e.getValue()))}))).collect(Collectors.toList());
            List<LamiTableEntryAspect> tableAspects = Arrays.asList(new LamiTableEntryAspect[]{new LamiCategoryAspect(Objects.requireNonNull(Messages.EthdevPollDistribution_NumberOfPacketsLabel), 0), new LamiCountAspect(Objects.requireNonNull(Messages.EthdevPollDistribution_CountLabel), 1)});
            LamiTableClass tableClass = new LamiTableClass(queueName, queueName, tableAspects, Collections.emptySet());
            results.add(new LamiResultTable(DpdkPollDistributionAnalysis.createTimeRange(timeRange), tableClass, tableEntries));
        }
        return results;
    }

    private static LamiTimeRange createTimeRange(TmfTimeRange timeRange) {
        return new LamiTimeRange(new LamiTimestamp(timeRange.getStartTime().toNanos()), new LamiTimestamp(timeRange.getEndTime().toNanos()));
    }

    private final class LamiCategoryAspect
    extends LamiGenericAspect {
        private LamiCategoryAspect(String name, int column) {
            super(name, null, column, false, false);
        }
    }

    private final class LamiCountAspect
    extends LamiGenericAspect {
        private LamiCountAspect(String name, int column) {
            super(name, null, column, true, false);
        }
    }

    private final class LamiString
    extends LamiData {
        private final String fElement;

        private LamiString(String element) {
            this.fElement = element;
        }

        public @Nullable String toString() {
            return this.fElement;
        }
    }
}

