/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.opentracing.core.event;

import com.google.common.collect.ImmutableList;
import java.text.Format;
import java.util.Collections;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.format.SubSecondTimeWithUnitFormat;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.event.IOpenTracingAspect;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.event.Messages;
import org.eclipse.tracecompass.incubator.internal.opentracing.core.event.OpenTracingEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;

public class OpenTracingAspects {
    private static @Nullable Iterable<@NonNull ITmfEventAspect<?>> aspects;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static Iterable<@NonNull ITmfEventAspect<?>> getAspects() {
        @NonNull ImmutableList aspectSet = aspects;
        if (aspectSet == null) {
            aspects = aspectSet = ImmutableList.of((Object)new OpenTracingLabelAspect(), (Object)TmfBaseAspects.getTimestampAspect(), (Object)new OpenTracingDurationAspect(), (Object)new OpenTracingSpanIdAspect(), (Object)new OpenTracingProcessAspect(), (Object)new OpenTracingProcessTagsAspect(), (Object)new OpenTracingTagsAspect());
        }
        return aspectSet;
    }

    private static class OpenTracingDurationAspect
    implements IOpenTracingAspect<String> {
        private static final Format FORMATTER = SubSecondTimeWithUnitFormat.getInstance();

        private OpenTracingDurationAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.OpenTracingAspects_Duration);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.OpenTracingAspects_DurationD);
        }

        @Override
        public @Nullable String resolveOpenTracingLogs(@NonNull OpenTracingEvent event) {
            return FORMATTER.format(event.getField().getDuration());
        }
    }

    private static class OpenTracingLabelAspect
    implements IOpenTracingAspect<String> {
        private OpenTracingLabelAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.OpenTracingAspects_Name);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.OpenTracingAspects_NameD);
        }

        @Override
        public String resolveOpenTracingLogs(@NonNull OpenTracingEvent event) {
            return event.getName();
        }
    }

    private static class OpenTracingProcessAspect
    implements IOpenTracingAspect<String> {
        private OpenTracingProcessAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.OpenTracingAspects_Process);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.OpenTracingAspects_ProcessD);
        }

        @Override
        public String resolveOpenTracingLogs(@NonNull OpenTracingEvent event) {
            String field = event.getField().getProcessName();
            return String.valueOf(field);
        }
    }

    private static class OpenTracingProcessTagsAspect
    implements IOpenTracingAspect<Map<String, Object>> {
        private OpenTracingProcessTagsAspect() {
        }

        public String getName() {
            return String.valueOf(Messages.OpenTracingAspects_ProcessTags);
        }

        public String getHelpText() {
            return String.valueOf(Messages.OpenTracingAspects_ProcessTagsD);
        }

        @Override
        public Map<String, Object> resolveOpenTracingLogs(@NonNull OpenTracingEvent event) {
            Map<String, Object> processTags = event.getField().getProcessTags();
            return processTags == null ? Collections.emptyMap() : processTags;
        }
    }

    private static class OpenTracingSpanIdAspect
    implements IOpenTracingAspect<String> {
        private OpenTracingSpanIdAspect() {
        }

        public @NonNull String getName() {
            return String.valueOf(Messages.OpenTracingAspects_SpanId);
        }

        public @NonNull String getHelpText() {
            return String.valueOf(Messages.OpenTracingAspects_SpanIdD);
        }

        @Override
        public String resolveOpenTracingLogs(@NonNull OpenTracingEvent event) {
            return event.getField().getSpanId();
        }
    }

    private static class OpenTracingTagsAspect
    implements IOpenTracingAspect<Map<String, Object>> {
        private OpenTracingTagsAspect() {
        }

        public String getName() {
            return String.valueOf(Messages.OpenTracingAspects_Tags);
        }

        public String getHelpText() {
            return String.valueOf(Messages.OpenTracingAspects_TagsD);
        }

        @Override
        public Map<String, Object> resolveOpenTracingLogs(@NonNull OpenTracingEvent event) {
            Map<String, Object> tags = event.getField().getTags();
            return tags == null ? Collections.emptyMap() : tags;
        }
    }
}

